/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mantle.world.CoordTuple;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.command.IEntitySelector;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import tmechworks.blocks.logic.SubFilter;
import tmechworks.client.block.FilterRender;
import tmechworks.lib.TMechworksRegistry;
import tmechworks.lib.blocks.IBlockWithMetadata;

public class FilterBlock
extends Block
implements IBlockWithMetadata {
    public static final double thickness = 0.1875;
    public static final double sideWidth = 0.2;
    public SubFilter[] subFilters = new SubFilter[8];
    protected IIcon[] subMeshIcons = new IIcon[8];
    protected static int ticksPerUpdate = 10;
    public static final double hackHeight = 0.05;

    public FilterBlock() {
        super(Material.field_151573_f);
        this.func_149647_a(TMechworksRegistry.Mechworks);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.1875f, 1.0f);
        this.func_149711_c(3.0f);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149655_b(IBlockAccess par1IBlockAccess, int x, int y, int z) {
        return true;
    }

    public int func_149645_b() {
        return FilterRender.renderID;
    }

    public IIcon getMeshIcon(int metadata) {
        if (this.subMeshIcons[metadata & 7] != null) {
            return this.subMeshIcons[metadata & 7];
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        for (int i = 1; i < 8; ++i) {
            if (this.subFilters[i] == null || this.subFilters[i].getMeshIconName() == null) continue;
            this.subMeshIcons[i] = iconRegister.func_94245_a(this.subFilters[i].getMeshIconName());
        }
    }

    public void setSubFilter(SubFilter setTo, int i) {
        if (i != 0 && i < 8) {
            this.subFilters[i] = setTo;
        }
    }

    public int getSubFilter(IBlockAccess world, CoordTuple position) {
        return this.getSubFilter(world.func_72805_g(position.x, position.y, position.z));
    }

    public int getSubFilter(int metadata) {
        return metadata & 7;
    }

    public boolean isTop(IBlockAccess world, CoordTuple position) {
        return (world.func_72805_g(position.x, position.y, position.z) & 8) != 0;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        if (this.isTop(world, new CoordTuple((double)x, (double)y, (double)z))) {
            this.func_149676_a(0.0f, 0.8125f, 0.0f, 1.0f, 0.95f, 1.0f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.1875f, 1.0f);
        }
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.1875f, 1.0f);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB region, List result, Entity entity) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        super.func_149743_a(world, x, y, z, region, result, entity);
    }

    private final AxisAlignedBB getOffsetAABB(double x, double y, double z, double x1, double y1, double z1, double x2, double y2, double z2) {
        return AxisAlignedBB.func_72330_a((double)(x + x1), (double)(y + y1), (double)(z + z1), (double)(x + x2), (double)(y + y2), (double)(z + z2));
    }

    public int func_149660_a(World par1World, int par2, int par3, int par4, int par5, float par6, float par7, float par8, int par9) {
        return par5 != 0 && (par5 == 1 || (double)par7 <= 0.5) ? par9 : par9 | 8;
    }

    public int func_149692_a(int meta) {
        return meta & 7;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean filter_shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        if (side != 1 && side != 0 && !super.func_149646_a(world, x, y, z, side)) {
            return false;
        }
        CoordTuple position = new CoordTuple((double)x, (double)y, (double)z);
        boolean flag = this.isTop(world, position);
        if (flag && side == 1) {
            return super.func_149646_a(world, position.x, position.y, position.z, side);
        }
        if (!flag && side == 0) {
            return super.func_149646_a(world, position.x, position.y, position.z, side);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public int func_149643_k(World par1World, int par2, int par3, int par4) {
        return super.func_149643_k(par1World, par2, par3, par4) & 7;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item ourItem, CreativeTabs tab, List list) {
        list.add(new ItemStack(ourItem, 1, 0));
        for (int i = 1; i < 8; ++i) {
            if (this.subFilters[i] == null) continue;
            list.add(new ItemStack(ourItem, 1, i));
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        block11: {
            boolean setEmpty;
            CoordTuple position;
            block13: {
                ItemStack playerItem;
                block12: {
                    if (world.field_72995_K) {
                        return !player.func_70093_af();
                    }
                    if (player.func_70093_af()) break block11;
                    position = new CoordTuple((double)x, (double)y, (double)z);
                    int metadata = world.func_72805_g(x, y, z);
                    setEmpty = false;
                    playerItem = player.field_71071_by.func_70448_g();
                    if (this.subFilters[metadata & 7] == null) break block12;
                    if (this.subFilters[this.getSubFilter(metadata)].getAssociatedItem() == null) break block13;
                    ItemStack item = this.subFilters[this.getSubFilter(metadata)].getAssociatedItem().func_77946_l();
                    EntityItem entityitem = new EntityItem(world, player.field_70165_t, player.field_70163_u - 1.0, player.field_70161_v, item);
                    world.func_72838_d((Entity)entityitem);
                    if (!(player instanceof FakePlayer)) {
                        entityitem.func_70100_b_(player);
                    }
                    setEmpty = true;
                    break block13;
                }
                if (playerItem != null) {
                    for (int i = 1; i < 8; ++i) {
                        if (this.subFilters[i] == null || this.subFilters[i].getAssociatedItem() == null || this.subFilters[i].getAssociatedItem().func_77973_b() == null || playerItem.func_77973_b() == null || this.subFilters[i].getAssociatedItem().func_77973_b() != playerItem.func_77973_b()) continue;
                        if (this.isTop((IBlockAccess)world, position)) {
                            world.func_72921_c(position.x, position.y, position.z, i | 8, 3);
                        } else {
                            world.func_72921_c(position.x, position.y, position.z, i, 3);
                        }
                        if (!player.field_71075_bZ.field_75098_d) {
                            --playerItem.field_77994_a;
                            if (playerItem.field_77994_a == 0) {
                                playerItem = null;
                            }
                        }
                        setEmpty = false;
                        break;
                    }
                }
            }
            if (setEmpty) {
                if (this.isTop((IBlockAccess)world, position)) {
                    world.func_72921_c(position.x, position.y, position.z, 8, 3);
                } else {
                    world.func_72921_c(position.x, position.y, position.z, 0, 3);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String getUnlocalizedNameByMetadata(int damageValue) {
        if (this.subFilters[this.getSubFilter(damageValue)] != null) {
            return this.func_149739_a() + "." + this.subFilters[this.getSubFilter(damageValue)].getSuffix();
        }
        return this.func_149739_a();
    }

    @Override
    public int getItemCount() {
        return 8;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity par5Entity) {
        super.func_149670_a(world, x, y, z, par5Entity);
        this.doFilterLogic(world, new CoordTuple((double)x, (double)y, (double)z));
    }

    public void doFilterLogic(World worldObj, CoordTuple position) {
        block10: {
            EntityItem entity;
            List list;
            boolean passable;
            int metadata;
            block11: {
                if (worldObj.func_82737_E() % (long)ticksPerUpdate != 0L) break block10;
                metadata = worldObj.func_72805_g(position.x, position.y, position.z);
                passable = false;
                if (worldObj.func_147439_a(position.x, position.y, position.z) == null) {
                    passable = true;
                } else if (!worldObj.func_147439_a(position.x, position.y - 1, position.z).func_149721_r()) {
                    passable = true;
                }
                IInventory inv = FilterBlock.getInventoryAtLocation(worldObj, position);
                if (inv != null && !this.isTop((IBlockAccess)worldObj, position)) {
                    list = FilterBlock.getEntitiesIn(worldObj, position);
                    for (Object item : list) {
                        if (!(item instanceof EntityItem)) continue;
                        entity = (EntityItem)item;
                        if (this.subFilters[this.getSubFilter(metadata)] == null || !this.subFilters[this.getSubFilter(metadata)].canPass((Entity)entity) || worldObj.field_72995_K) continue;
                        FilterBlock.insertStackFromEntity(inv, entity);
                    }
                }
                if ((inv = FilterBlock.getInventoryAtLocation(worldObj, position)) == null) break block11;
                if (!this.isTop((IBlockAccess)worldObj, position)) break block10;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack itemStack = inv.func_70301_a(i);
                    if (itemStack == null || this.subFilters[this.getSubFilter(metadata)] == null || !this.subFilters[this.getSubFilter(metadata)].canPass(itemStack) || worldObj.field_72995_K) continue;
                    ItemStack resultStack = inv.func_70298_a(i, itemStack.field_77994_a);
                    EntityItem entityItem = new EntityItem(worldObj, (double)position.x + 0.5, (double)position.y + (0.5 - 0.1875), (double)position.z + 0.5);
                    entityItem.func_92058_a(resultStack);
                    worldObj.func_72838_d((Entity)entityItem);
                    entityItem.field_70159_w = 0.0;
                    entityItem.field_70181_x = -entityItem.field_70181_x;
                    entityItem.field_70179_y = 0.0;
                }
                break block10;
            }
            if (passable) {
                list = null;
                list = this.isTop((IBlockAccess)worldObj, position) ? FilterBlock.getEntitiesIn(worldObj, position.x, position.y + 1, position.z) : FilterBlock.getEntitiesIn(worldObj, position);
                if (list != null) {
                    for (Object item : list) {
                        if (!(item instanceof Entity)) continue;
                        entity = (Entity)item;
                        if (this.subFilters[this.getSubFilter(metadata)] == null || !this.subFilters[this.getSubFilter(metadata)].canPass((Entity)entity)) continue;
                        entity.field_70159_w = 0.0;
                        entity.field_70179_y = 0.0;
                        if (this.isTop((IBlockAccess)worldObj, position)) {
                            entity.func_70107_b(entity.field_70165_t, (double)position.y + (0.5 - 0.1875), entity.field_70161_v);
                            continue;
                        }
                        entity.func_70107_b(entity.field_70165_t, (double)position.y - ((double)entity.field_70131_O + 0.1), entity.field_70161_v);
                    }
                }
            }
        }
    }

    public static List getEntitiesIn(World world, CoordTuple pos) {
        return FilterBlock.getEntitiesIn(world, pos.x, pos.y, pos.z);
    }

    protected static List getEntitiesIn(World world, int x, int y, int z) {
        return world.func_82733_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)((double)x + 1.0), (double)((double)y + 1.0), (double)((double)z + 1.0)), IEntitySelector.field_94557_a);
    }

    public static IInventory getInventoryAtLocation(World world, CoordTuple position) {
        TileEntity tileentity = world.func_147438_o(position.x, position.y, position.z);
        if (tileentity != null && tileentity instanceof IInventory) {
            return (IInventory)tileentity;
        }
        return null;
    }

    public static boolean insertStackFromEntity(IInventory inv, EntityItem entity) {
        boolean flag = false;
        if (entity != null) {
            ItemStack itemstack = entity.func_92059_d().func_77946_l();
            ItemStack itemstack1 = FilterBlock.insertStack(inv, itemstack);
            if (itemstack1 != null && itemstack1.field_77994_a != 0) {
                entity.func_92058_a(itemstack1);
            } else {
                flag = true;
                entity.func_70106_y();
            }
        }
        return flag;
    }

    public static ItemStack insertStack(IInventory inv, ItemStack itemStack) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack slotStack = inv.func_70301_a(i);
            int remainingSpace = inv.func_70297_j_();
            if (slotStack != null) {
                remainingSpace -= slotStack.field_77994_a;
            }
            if (remainingSpace >= itemStack.field_77994_a) {
                if (slotStack != null) {
                    if (!slotStack.func_77969_a(itemStack)) continue;
                    slotStack.field_77994_a += itemStack.field_77994_a;
                    inv.func_70299_a(i, slotStack);
                    return null;
                }
                if (!inv.func_94041_b(i, itemStack)) continue;
                inv.func_70299_a(i, itemStack);
                return null;
            }
            if (slotStack != null) {
                if (!slotStack.func_77969_a(itemStack)) continue;
                slotStack.field_77994_a += remainingSpace;
                itemStack.field_77994_a -= remainingSpace;
                inv.func_70299_a(i, slotStack);
                continue;
            }
            if (!inv.func_94041_b(i, itemStack)) continue;
            inv.func_70299_a(i, itemStack.func_77979_a(remainingSpace));
        }
        return itemStack;
    }
}

