/*
 * Decompiled with CFR 0.152.
 */
package taintedmagic.common.helper;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.api.wands.StaffRod;
import thaumcraft.codechicken.lib.vec.Vector3;
import thaumcraft.common.items.wands.ItemWandCasting;

public class TaintedMagicHelper {
    public static AspectList getPrimals(int amount) {
        return new AspectList().add(Aspect.FIRE, amount).add(Aspect.WATER, amount).add(Aspect.EARTH, amount).add(Aspect.AIR, amount).add(Aspect.ORDER, amount).add(Aspect.ENTROPY, amount);
    }

    public static Vector3 getDistanceBetween(Entity e, Entity target) {
        Vector3 fromPosition = new Vector3(e.field_70165_t, e.field_70163_u, e.field_70161_v);
        Vector3 toPosition = new Vector3(target.field_70165_t, target.field_70163_u, target.field_70161_v);
        Vector3 dist = fromPosition.sub(toPosition);
        dist.normalize();
        return dist;
    }

    public static double getDistanceTo(double x, double y, double z, EntityPlayer p) {
        double var7 = p.field_70165_t + 0.5 - x;
        double var9 = p.field_70163_u + 0.5 - y;
        double var11 = p.field_70161_v + 0.5 - z;
        return var7 * var7 + var9 * var9 + var11 * var11;
    }

    public static int getFocusDamageWithPotency(ItemStack stack, int damage) {
        if (stack != null && stack.func_77973_b() instanceof ItemWandCasting) {
            ItemWandCasting wand = (ItemWandCasting)stack.func_77973_b();
            return (int)((double)damage + (double)(damage * wand.getFocusPotency(stack)) * 0.2 + 0.5);
        }
        if (stack != null && stack.func_77973_b() instanceof ItemFocusBasic) {
            ItemFocusBasic focus = (ItemFocusBasic)stack.func_77973_b();
            return (int)((double)damage + (double)(damage * focus.getUpgradeLevel(stack, FocusUpgradeType.potency)) * 0.2 + 0.5);
        }
        return damage;
    }

    public static float getFocusDamageWithPotency(ItemStack stack, int damage, float staffBuff) {
        ItemWandCasting wand;
        if (stack != null && stack.func_77973_b() instanceof ItemWandCasting && (wand = (ItemWandCasting)stack.func_77973_b()).getRod(stack) instanceof StaffRod) {
            return (float)TaintedMagicHelper.getFocusDamageWithPotency(stack, damage) * staffBuff;
        }
        return TaintedMagicHelper.getFocusDamageWithPotency(stack, damage);
    }

    public static boolean hasFocusUpgrade(ItemStack stack, FocusUpgradeType upgrade) {
        if (stack != null) {
            ItemStack fociStack;
            ItemFocusBasic foci;
            Item item = stack.func_77973_b();
            if (item instanceof ItemWandCasting) {
                ItemWandCasting wand = (ItemWandCasting)item;
                foci = wand.getFocus(stack);
                fociStack = wand.getFocusItem(stack);
            } else if (item instanceof ItemFocusBasic) {
                foci = (ItemFocusBasic)item;
                fociStack = stack;
            } else {
                return false;
            }
            return foci.isUpgradedWith(fociStack, upgrade);
        }
        return false;
    }

    public static int getFocusLevelUpgrade(ItemStack stack, FocusUpgradeType upgrade) {
        if (stack != null) {
            ItemStack fociStack;
            ItemFocusBasic foci;
            Item item = stack.func_77973_b();
            if (item instanceof ItemWandCasting) {
                ItemWandCasting wand = (ItemWandCasting)item;
                foci = wand.getFocus(stack);
                fociStack = wand.getFocusItem(stack);
            } else if (item instanceof ItemFocusBasic) {
                foci = (ItemFocusBasic)item;
                fociStack = stack;
            } else {
                return 0;
            }
            return foci.getUpgradeLevel(fociStack, upgrade);
        }
        return 0;
    }

    public static List addTooltipBaseDamage(List list, int damage, ItemStack stack) {
        list.add(EnumChatFormatting.BLUE + "" + TaintedMagicHelper.getFocusDamageWithPotency(stack, damage) + " " + StatCollector.func_74838_a((String)"text.attackdamageequipped"));
        return list;
    }

    public static List addTooltipStaffMultiplier(List list, float multiplier) {
        list.add(EnumChatFormatting.BLUE + String.format(StatCollector.func_74838_a((String)"focus.upgrade.staff_tooltip.tip"), Float.valueOf(multiplier)));
        return list;
    }

    public static List addTooltipDamageAndStaffMultiplier(List list, int damage, ItemStack stack, float multiplier) {
        list.add("");
        TaintedMagicHelper.addTooltipBaseDamage(list, damage, stack);
        TaintedMagicHelper.addTooltipStaffMultiplier(list, multiplier);
        list.add("");
        return list;
    }
}

