/*
 * Decompiled with CFR 0.152.
 */
package taintedmagic.common.items.wand.foci;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import taintedmagic.common.TaintedMagic;
import taintedmagic.common.handler.ConfigHandler;
import taintedmagic.common.helper.TaintedMagicHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.items.wands.ItemWandCasting;

public class ItemFocusTaintedBlast
extends ItemFocusBasic {
    private static final AspectList costBase = new AspectList().add(Aspect.ENTROPY, 1000).add(Aspect.EARTH, 1000).add(Aspect.WATER, 1000);
    private final AspectList costEnlarge = new AspectList().add(Aspect.ENTROPY, 250).add(Aspect.EARTH, 250).add(Aspect.WATER, 250);
    public static IIcon depthIcon;
    public static IIcon ornIcon;

    public ItemFocusTaintedBlast() {
        this.func_77637_a(TaintedMagic.tabTaintedMagic);
        this.func_77655_b("ItemFocusTaintedBlast");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon = ir.func_94245_a("taintedmagic:ItemFocusTaintedBlast");
        depthIcon = ir.func_94245_a("taintedmagic:ItemFocusTaint_depth");
        ornIcon = ir.func_94245_a("taintedmagic:ItemFocusTaintedBlast_orn");
    }

    public IIcon getFocusDepthLayerIcon(ItemStack stack) {
        return depthIcon;
    }

    public IIcon getOrnament(ItemStack stack) {
        return ornIcon;
    }

    public String getSortingHelper(ItemStack stack) {
        return "SHOCKWAVE" + super.getSortingHelper(stack);
    }

    public int getFocusColor(ItemStack stack) {
        return 13107455;
    }

    public AspectList getVisCost(ItemStack stack) {
        AspectList list = costBase.copy();
        if (TaintedMagicHelper.hasFocusUpgrade(stack, FocusUpgradeType.enlarge)) {
            int focusUpgradeLevel = TaintedMagicHelper.getFocusLevelUpgrade(stack, FocusUpgradeType.enlarge);
            for (int i = 0; i < focusUpgradeLevel; ++i) {
                list.add(this.costEnlarge);
            }
        }
        return list;
    }

    public int getActivationCooldown(ItemStack stack) {
        return 6000;
    }

    public boolean isVisCostPerTick(ItemStack stack) {
        return false;
    }

    public ItemFocusBasic.WandFocusAnimation getAnimation(ItemStack stack) {
        return ItemFocusBasic.WandFocusAnimation.WAVE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b) {
        super.func_77624_a(stack, player, list, b);
        list.add(EnumChatFormatting.BLUE + "+" + (this.isUpgradedWith(stack, FocusUpgradeType.enlarge) ? Integer.toString(10 + this.getUpgradeLevel(stack, FocusUpgradeType.enlarge) * 2) : "10") + " " + StatCollector.func_74838_a((String)"text.radius"));
        if (ConfigHandler.taintStormStaffMultiple != 1.0f) {
            list = TaintedMagicHelper.addTooltipDamageAndStaffMultiplier(list, ConfigHandler.taintedBlastBaseDamage, stack, ConfigHandler.taintedBlastStaffMultiple);
        }
    }

    public ItemStack onFocusRightClick(ItemStack stack, World world, EntityPlayer player, MovingObjectPosition mop) {
        ItemWandCasting wand = (ItemWandCasting)stack.func_77973_b();
        if (wand.consumeAllVis(stack, player, this.getVisCost(stack), true, false)) {
            double radius = 10.0 + (double)(2 * TaintedMagicHelper.getFocusLevelUpgrade(stack, FocusUpgradeType.enlarge));
            float damage = TaintedMagicHelper.getFocusDamageWithPotency(stack, ConfigHandler.taintedBlastBaseDamage, ConfigHandler.taintedBlastStaffMultiple);
            float reclining = ConfigHandler.taintedBlastReclining / 5.0f;
            List ents = world.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)(player.field_70165_t + 1.0), (double)(player.field_70163_u + 1.0), (double)(player.field_70161_v + 1.0)).func_72314_b(radius, radius, radius));
            if (ents != null && ents.size() > 0) {
                for (EntityLivingBase e : ents) {
                    if (e == player || !e.func_70089_S() || e.func_85032_ar()) continue;
                    e.func_70097_a(DamageSource.field_76376_m, damage);
                    e.func_70024_g((double)reclining, (double)reclining, (double)reclining);
                }
            }
            world.func_72956_a((Entity)player, "taintedmagic:shockwave", 5.0f, (float)Math.random());
            TaintedMagic.proxy.spawnShockwaveParticles(player.field_70170_p);
            return stack;
        }
        return null;
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack stack, int rank) {
        switch (rank) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.enlarge, FocusUpgradeType.potency};
            }
        }
        return null;
    }
}

