/*
 * Decompiled with CFR 0.152.
 */
package tb.common.item;

import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import tb.init.TBItems;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.wands.IWandable;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.items.wands.WandManager;

public class ItemCastingBracelet
extends ItemWandCasting {
    public static String[] names = new String[]{"iron", "gold", "greatwood", "thaumium", "silverwood", "reed", "bone", "obsidian", "blaze", "ice", "quartz", "void", "primal"};
    public static ResourceLocation[] braceletTextures = new ResourceLocation[]{ItemCastingBracelet.loc("thaumcraft", "textures/blocks/metalbase.png"), ItemCastingBracelet.loc("thaumcraft", "textures/blocks/goldbase.png"), ItemCastingBracelet.loc("thaumcraft", "textures/blocks/planks_greatwood.png"), ItemCastingBracelet.loc("thaumcraft", "textures/blocks/thaumiumblock.png"), ItemCastingBracelet.loc("thaumcraft", "textures/blocks/planks_silverwood.png"), ItemCastingBracelet.loc("thaumicbases", "textures/blocks/sugarcaneblock.png"), ItemCastingBracelet.loc("thaumicbases", "textures/blocks/boneblock.png"), ItemCastingBracelet.loc("minecraft", "textures/blocks/obsidian.png"), ItemCastingBracelet.loc("thaumicbases", "textures/blocks/blazeblock.png"), ItemCastingBracelet.loc("minecraft", "textures/blocks/ice_packed.png"), ItemCastingBracelet.loc("minecraft", "textures/blocks/quartz_block_bottom.png"), ItemCastingBracelet.loc("thaumicbases", "textures/blocks/voidblock.png"), ItemCastingBracelet.loc("thaumcraft", "textures/blocks/deco_3.png")};
    public static WandCap[] caps = new WandCap[]{ConfigItems.WAND_CAP_IRON, ConfigItems.WAND_CAP_GOLD, ConfigItems.WAND_CAP_GOLD, TBItems.WAND_CAP_THAUMINITE, ConfigItems.WAND_CAP_THAUMIUM, ConfigItems.WAND_CAP_THAUMIUM, ConfigItems.WAND_CAP_THAUMIUM, ConfigItems.WAND_CAP_THAUMIUM, ConfigItems.WAND_CAP_THAUMIUM, ConfigItems.WAND_CAP_THAUMIUM, ConfigItems.WAND_CAP_THAUMIUM, ConfigItems.WAND_CAP_THAUMIUM, ConfigItems.WAND_CAP_VOID};
    public static WandRod[] rods = new WandRod[]{ConfigItems.WAND_ROD_WOOD, ConfigItems.WAND_ROD_WOOD, ConfigItems.WAND_ROD_GREATWOOD, TBItems.WAND_ROD_THAUMIUM, ConfigItems.WAND_ROD_SILVERWOOD, ConfigItems.WAND_ROD_REED, ConfigItems.WAND_ROD_BONE, ConfigItems.WAND_ROD_OBSIDIAN, ConfigItems.WAND_ROD_BLAZE, ConfigItems.WAND_ROD_ICE, ConfigItems.WAND_ROD_QUARTZ, TBItems.WAND_ROD_VOID, ConfigItems.STAFF_ROD_PRIMAL};
    public static int[] capacity = new int[]{10, 15, 17, 20, 23, 23, 25, 25, 25, 25, 25, 27, 30};

    public ItemCastingBracelet() {
        this.func_77627_a(true);
    }

    public int getMaxVis(ItemStack stack) {
        return capacity[Math.min(names.length - 1, stack.func_77960_j())] * 100;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List lst) {
        for (int i = 0; i < names.length; ++i) {
            lst.add(new ItemStack(item, 1, i));
        }
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer player) {
        ItemFocusBasic focus;
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, true);
        if (movingobjectposition != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            ItemStack is;
            ItemStack is2;
            int x = movingobjectposition.field_72311_b;
            int y = movingobjectposition.field_72312_c;
            int z = movingobjectposition.field_72309_d;
            Block b = world.func_147439_a(x, y, z);
            if (b instanceof IWandable && (is2 = ((IWandable)b).onWandRightClick(world, itemstack, player)) != null) {
                return is2;
            }
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile != null && tile instanceof IWandable && (is = ((IWandable)tile).onWandRightClick(world, itemstack, player)) != null) {
                return is;
            }
        }
        if ((focus = this.getFocus(itemstack)) != null && !this.isOnCooldown((EntityLivingBase)player)) {
            WandManager.setCooldown((EntityLivingBase)player, (int)(focus.getActivationCooldown(this.getFocusItem(itemstack)) / 2));
            ItemStack ret = focus.onFocusRightClick(itemstack, world, player, movingobjectposition);
            if (ret != null) {
                return ret;
            }
        }
        return itemstack;
    }

    public boolean isOnCooldown(EntityLivingBase base) {
        try {
            Class<WandManager> manager = WandManager.class;
            Method method = manager.getDeclaredMethod("isOnCooldown", EntityLivingBase.class);
            boolean access = method.isAccessible();
            if (!access) {
                method.setAccessible(true);
            }
            boolean ret = (Boolean)Boolean.class.cast(method.invoke(null, base));
            if (!access) {
                method.setAccessible(false);
            }
            return ret;
        }
        catch (Exception e) {
            return true;
        }
    }

    public String func_77653_i(ItemStack stk) {
        return StatCollector.func_74838_a((String)this.func_77667_c(stk));
    }

    public String func_77667_c(ItemStack stk) {
        return super.func_77667_c(stk) + "." + names[Math.min(names.length - 1, stk.func_77960_j())];
    }

    public float getConsumptionModifier(ItemStack is, EntityPlayer player, Aspect aspect, boolean crafting) {
        float consumptionModifier = 0.5f;
        consumptionModifier = this.getCap(is).getSpecialCostModifierAspects() != null && this.getCap(is).getSpecialCostModifierAspects().contains(aspect) ? this.getCap(is).getSpecialCostModifier() / 1.5f : this.getCap(is).getBaseCostModifier() / 1.5f;
        if (player != null) {
            consumptionModifier -= WandManager.getTotalVisDiscount((EntityPlayer)player, (Aspect)aspect);
        }
        if (this.getFocus(is) != null && !crafting) {
            consumptionModifier -= (float)this.getFocusFrugal(is) / 11.0f;
        }
        return Math.max(consumptionModifier, 0.1f);
    }

    public WandRod getRod(ItemStack stack) {
        return stack.func_77960_j() == 3 ? TBItems.WAND_ROD_THAUMIUM : (stack.func_77960_j() == 11 ? TBItems.WAND_ROD_VOID : rods[Math.min(rods.length - 1, stack.func_77960_j())]);
    }

    public WandCap getCap(ItemStack stack) {
        return stack.func_77960_j() == 3 ? TBItems.WAND_CAP_THAUMINITE : caps[Math.min(caps.length - 1, stack.func_77960_j())];
    }

    public boolean isStaff(ItemStack stack) {
        return true;
    }

    public boolean isSceptre(ItemStack stack) {
        return false;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        IWandable wandable = this.getObjectInUse(stack, player.field_70170_p);
        if (wandable != null) {
            this.animation = ItemFocusBasic.WandFocusAnimation.WAVE;
            wandable.onUsingWandTick(stack, player, count);
            wandable.onUsingWandTick(stack, player, ++count);
        } else {
            ItemFocusBasic focus = this.getFocus(stack);
            if (focus != null && !this.isOnCooldown((EntityLivingBase)player)) {
                WandManager.setCooldown((EntityLivingBase)player, (int)(focus.getActivationCooldown(this.getFocusItem(stack)) / 2));
                focus.onUsingFocusTick(stack, player, count);
                focus.onUsingFocusTick(stack, player, ++count);
            }
        }
    }

    public static final ResourceLocation loc(String mod, String path) {
        return new ResourceLocation(mod, path);
    }
}

