/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mantle.world.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidFinite;
import tconstruct.TConstruct;
import twilightforest.integration.TFTinkerConstructIntegration;

public class TFFilledBucket
extends ItemBucket {
    public IIcon[] icons;
    public static final String[] materialNames = new String[]{"FieryEssence", "FieryMetal", "Knightmetal"};
    public static final String[] textureNames = new String[]{"fiery_essence", "fiery_metal", "knightmetal"};

    public TFFilledBucket(Block b) {
        super(b);
        this.func_77655_b("tconstruct.bucket");
        this.func_77642_a(Items.field_151133_ar);
        this.func_77627_a(true);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        boolean wannabeFull = false;
        MovingObjectPosition position = this.func_77621_a(world, player, wannabeFull);
        if (position != null && position.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int clickX = position.field_72311_b;
            int clickY = position.field_72312_c;
            int clickZ = position.field_72309_d;
            if (!world.func_72962_a(player, clickX, clickY, clickZ)) {
                return stack;
            }
            if (position.field_72310_e == 0) {
                --clickY;
            }
            if (position.field_72310_e == 1) {
                ++clickY;
            }
            if (position.field_72310_e == 2) {
                --clickZ;
            }
            if (position.field_72310_e == 3) {
                ++clickZ;
            }
            if (position.field_72310_e == 4) {
                --clickX;
            }
            if (position.field_72310_e == 5) {
                ++clickX;
            }
            if (!player.func_82247_a(clickX, clickY, clickZ, position.field_72310_e, stack)) {
                return stack;
            }
            if (this.tryPlaceContainedLiquid(world, clickX, clickY, clickZ, stack.func_77960_j()) && !player.field_71075_bZ.field_75098_d) {
                return new ItemStack(Items.field_151133_ar);
            }
        }
        return stack;
    }

    public boolean tryPlaceContainedLiquid(World world, int clickX, int clickY, int clickZ, int type) {
        if (!WorldHelper.isAirBlock((World)world, (int)clickX, (int)clickY, (int)clickZ) && world.func_147439_a(clickX, clickY, clickZ).func_149688_o().func_76220_a()) {
            return false;
        }
        try {
            if (TFTinkerConstructIntegration.fluidBlocks[type] == null) {
                return false;
            }
            int metadata = 0;
            if (TFTinkerConstructIntegration.fluidBlocks[type] instanceof BlockFluidFinite) {
                metadata = 7;
            }
            world.func_147465_d(clickX, clickY, clickZ, TFTinkerConstructIntegration.fluidBlocks[type], metadata, 3);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            TConstruct.logger.warn("AIOBE occured when placing bucket into world; " + ex);
            return false;
        }
        return true;
    }

    public void func_150895_a(Item b, CreativeTabs tab, List list) {
        for (int i = 0; i < this.icons.length; ++i) {
            list.add(new ItemStack(b, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        return this.icons[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.icons = new IIcon[textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("tinker:materials/bucket_" + textureNames[i]);
        }
    }

    public String func_77667_c(ItemStack stack) {
        int arr = MathHelper.func_76125_a((int)stack.func_77960_j(), (int)0, (int)materialNames.length);
        return this.func_77658_a() + "." + materialNames[arr];
    }
}

