/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.impl;

import com.gitlab.cdagaming.unilib.core.utils.ModUpdaterUtils;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ScrollPane;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.TextDisplayWidget;
import io.github.cdagaming.unicore.utils.UrlUtils;
import java.util.Map;

public class UpdateInfoGui
extends ExtendedScreen {
    private final String changelogPrefix = "Changelog:";
    private final ModUpdaterUtils modUpdater;
    private TextDisplayWidget infoPane;
    private ExtendedButtonControl downloadButton;
    private ExtendedButtonControl checkButton;

    public UpdateInfoGui(String modID, ModUpdaterUtils modUpdater) {
        super(UpdateInfoGui.jvmdowngrader$concat$$init$$1(modID));
        this.modUpdater = modUpdater;
    }

    @Override
    public void initializeUi() {
        this.checkButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getScreenHeight() - 26, 180, 20, "Check for Updates", () -> {
            this.updateInfo(ModUpdaterUtils.UpdateState.PENDING.getDisplayName());
            this.resetNotes();
            this.modUpdater.checkForUpdates(this::updateNotes);
        }, new String[0]));
        this.addControl(new ExtendedButtonControl(6, this.getScreenHeight() - 26, 95, 20, "Back", () -> this.openScreen(this.getParent()), new String[0]));
        this.downloadButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() - 101, this.getScreenHeight() - 26, 95, 20, "Download", () -> UrlUtils.openUrl(this.modUpdater.getDownloadUrl()), new String[0]));
        ScrollPane childFrame = this.addControl(new ScrollPane(0, 32, this.getScreenWidth(), this.getScreenHeight() - 64));
        this.infoPane = childFrame.addWidget(new TextDisplayWidget(0, 0, childFrame.getScreenWidth()));
        this.updateNotes();
        super.initializeUi();
    }

    @Override
    public void preRender() {
        this.downloadButton.setControlEnabled(this.modUpdater.getStatus() == ModUpdaterUtils.UpdateState.OUTDATED || this.modUpdater.getStatus() == ModUpdaterUtils.UpdateState.BETA_OUTDATED);
        this.checkButton.setControlEnabled(this.modUpdater.getStatus() != ModUpdaterUtils.UpdateState.PENDING);
        super.preRender();
    }

    private void resetNotes() {
        String notice = "Changelog:\n  N/A";
        this.infoPane.setMessage("Changelog:\n  N/A");
    }

    private void updateNotes() {
        if (this.modUpdater.hasChanges()) {
            StringBuilder notice = new StringBuilder();
            notice.append("Changelog:");
            for (Map.Entry<String, String> entry : this.modUpdater.getChanges()) {
                notice.append('\n').append("  ").append(entry.getKey()).append(":").append('\n').append(entry.getValue()).append('\n').append(' ');
            }
            this.infoPane.setMessage(notice.toString());
        } else {
            this.resetNotes();
        }
        this.updateInfo();
    }

    private void updateInfo(String status) {
        this.setScreenSubTitle(String.format("Version Check Info (State: %1$s)", status));
    }

    private void updateInfo() {
        this.updateInfo(this.modUpdater.getStatus().getDisplayName());
    }

    private static String jvmdowngrader$concat$$init$$1(String string) {
        return string + " - Update Info";
    }
}

