/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdagaming.unicore.utils;

import io.github.cdagaming.unicore.UniCore;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.io.IOException;
import java.util.List;
import java.util.Random;

public class OSUtils {
    public static final Random RANDOM = new Random();
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String USER_DIR = System.getProperty("user.dir");
    public static final boolean IS_LINUX = OS_NAME.startsWith("Linux") || OS_NAME.startsWith("LINUX");
    public static final boolean IS_MAC = OS_NAME.startsWith("Mac");
    public static final boolean IS_WINDOWS = OS_NAME.startsWith("Windows");
    public static final boolean IS_64_BIT = OS_ARCH.contains("amd64") || OS_ARCH.contains("x86_64");
    public static final float JAVA_SPEC = Float.parseFloat(System.getProperty("java.specification.version"));

    public static boolean browseWithSystem(String cmd) {
        if (IS_LINUX) {
            if (OSUtils.isXDG() && OSUtils.runCommand("xdg-open", "%s", cmd)) {
                return true;
            }
            if (OSUtils.isKDE() && OSUtils.runCommand("kde-open", "%s", cmd)) {
                return true;
            }
            if (OSUtils.isGNOME() && OSUtils.runCommand("gnome-open", "%s", cmd)) {
                return true;
            }
            if (OSUtils.runCommand("kde-open", "%s", cmd)) {
                return true;
            }
            if (OSUtils.runCommand("gnome-open", "%s", cmd)) {
                return true;
            }
        }
        if (IS_MAC && OSUtils.runCommand("open", "%s", cmd)) {
            return true;
        }
        return IS_WINDOWS && OSUtils.runCommand("explorer", "%s", cmd);
    }

    private static boolean runCommand(String command, String args, String file) {
        UniCore.LOG.debugInfo("Trying to exec: [cmd=\"%s\", args=\"%s\", file=\"%s\"]", command, args, file);
        String[] parts = OSUtils.prepareCommand(command, args, file);
        try {
            Process p = Runtime.getRuntime().exec(parts);
            try {
                int retval = p.exitValue();
                if (retval == 0) {
                    UniCore.LOG.debugError("Process ended immediately.", new Object[0]);
                } else {
                    UniCore.LOG.debugError("Process crashed.", new Object[0]);
                }
                return false;
            }
            catch (IllegalThreadStateException itse) {
                UniCore.LOG.debugError("Process is running.", new Object[0]);
                return true;
            }
        }
        catch (IOException e) {
            UniCore.LOG.debugError("Error running command.", e);
            return false;
        }
    }

    private static String[] prepareCommand(String command, String args, String file) {
        List<String> parts = StringUtils.newArrayList();
        parts.add(command);
        if (args != null) {
            for (String s : args.split(" ")) {
                s = String.format(s, file);
                parts.add(s.trim());
            }
        }
        return parts.toArray(new String[0]);
    }

    public static boolean isXDG() {
        String xdgSessionId = System.getenv("XDG_SESSION_ID");
        return xdgSessionId != null && !xdgSessionId.isEmpty();
    }

    public static boolean isGNOME() {
        String gdmSession = System.getenv("GDMSESSION");
        return gdmSession != null && gdmSession.toLowerCase().contains("gnome");
    }

    public static boolean isKDE() {
        String gdmSession = System.getenv("GDMSESSION");
        return gdmSession != null && gdmSession.toLowerCase().contains("kde");
    }
}

