/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.logic;

import codechicken.core.ClientUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.wirelessredstone.core.ITileJammer;
import codechicken.wirelessredstone.core.ITileWireless;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.core.WirelessBolt;
import codechicken.wirelessredstone.logic.TransmitterPart;
import codechicken.wirelessredstone.logic.WirelessPart;
import codechicken.wirelessredstone.logic.WirelessRedstoneLogic;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;

public class JammerPart
extends WirelessPart
implements ITileJammer {
    int randfreqspeed;

    public JammerPart() {
        this.setActive(true);
    }

    @Override
    public ItemStack getItem() {
        return new ItemStack(WirelessRedstoneLogic.itemwireless, 1, 2);
    }

    @Override
    public int textureSet() {
        return this.active() ? 0 : 1;
    }

    @Override
    public void onNeighborChanged() {
        if (this.dropIfCantStay()) {
            return;
        }
        int gettingPowered = this.getPoweringLevel();
        if (this.active() && gettingPowered > 0) {
            this.setActive(false);
            this.removeFromEther();
            this.updateChange();
        } else if (!this.active() && gettingPowered == 0) {
            this.setActive(true);
            this.addToEther();
            this.updateChange();
        }
    }

    @Override
    public Vector3 getPearlPos() {
        return new Vector3(0.5, 0.74 + this.getFloating() * 0.04, 0.3125);
    }

    @Override
    public double getPearlSpin() {
        if (this.world().field_73012_v.nextInt(100) == 0 || this.randfreqspeed == 0) {
            this.randfreqspeed = this.world().field_73012_v.nextInt(5000) + 1;
        }
        if (!this.active()) {
            return 0.0;
        }
        return RedstoneEther.getRotation(ClientUtils.getRenderTime(), this.randfreqspeed);
    }

    @Override
    public float getPearlLight() {
        float light = this.world().func_72801_o(this.x(), this.y(), this.z());
        light = this.active() ? (light + 1.0f) * 0.5f : (light *= 0.75f);
        return light;
    }

    @Override
    public void onWorldJoin() {
        if (!this.world().field_72995_K && this.active()) {
            this.addToEther();
        }
    }

    @Override
    public void onWorldSeparate() {
        if (!this.world().field_72995_K && this.active()) {
            this.removeFromEther();
        }
    }

    @Override
    public Vector3 getFocalPoint() {
        return new Vector3(0.3125, 0.24, 0.0).apply(this.rotationT());
    }

    @Override
    public void jamTile(ITileWireless tile) {
        WirelessBolt bolt = new WirelessBolt(this.world(), WirelessBolt.getFocalPoint((ITileJammer)this.tile()), tile, this.world().field_73012_v.nextLong());
        bolt.defaultFractal();
        bolt.finalizeBolt();
    }

    @Override
    public void jamEntity(Entity entity) {
        WirelessBolt bolt = new WirelessBolt(this.world(), WirelessBolt.getFocalPoint((ITileJammer)this.tile()), Vector3.fromEntity((Entity)entity), this.world().field_73012_v.nextLong());
        bolt.defaultFractal();
        bolt.finalizeBolt();
    }

    @Override
    public void addToEther() {
        if (this.active()) {
            RedstoneEther.server().addJammer(this.world(), this.x(), this.y(), this.z());
        }
    }

    @Override
    public void removeFromEther() {
        RedstoneEther.server().remJammer(this.world(), this.x(), this.y(), this.z());
    }

    public String getType() {
        return "wrcbe-jamm";
    }

    @Override
    public Cuboid6 getExtensionBB() {
        return TransmitterPart.extensionBB[this.shape()];
    }

    @Override
    public int modelId() {
        return 2;
    }
}

