/*
 * Decompiled with CFR 0.152.
 */
package alkalus.main.core;

import alkalus.main.api.plugin.base.BasePluginWitchery;
import alkalus.main.core.crafting.OvenRecipes;
import alkalus.main.core.entities.PredictionHandler;
import alkalus.main.core.recipe.fixes.GarlicRecipes;
import alkalus.main.core.util.Logger;
import alkalus.main.core.util.TooltipHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="WitcheryExtras", name="Witchery++", version="1.3.7", dependencies="required-after:witchery;required-after:spongemixins;")
public class WitcheryExtras {
    public static final String MODID = "WitcheryExtras";
    public static final String NAME = "Witchery++";
    public static final String VERSION = "1.3.7";
    private static final Map<Integer, BasePluginWitchery> mPreInitEvents = new HashMap<Integer, BasePluginWitchery>();
    private static final Map<Integer, BasePluginWitchery> mInitEvents = new HashMap<Integer, BasePluginWitchery>();
    private static final Map<Integer, BasePluginWitchery> mPostInitEvents = new HashMap<Integer, BasePluginWitchery>();
    @Mod.Instance(value="WitcheryExtras")
    public static WitcheryExtras instance;
    private static int mID_1;
    private static int mID_2;
    private static int mID_3;

    @Mod.EventHandler
    public synchronized void preInit(FMLPreInitializationEvent e) {
        WitcheryExtras.log(0, "Loading Witchery++ - v1.3.7");
        for (BasePluginWitchery bwp : WitcheryExtras.getMpreinitevents()) {
            WitcheryExtras.log(0, "Loading Plugin: " + bwp.getPluginName() + " | Phase: Pre-Init");
            bwp.preInit();
        }
    }

    @Mod.EventHandler
    public synchronized void init(FMLInitializationEvent e) {
        new GarlicRecipes();
        OvenRecipes.generateDefaultOvenRecipes();
        for (BasePluginWitchery bwp : WitcheryExtras.getMinitevents()) {
            WitcheryExtras.log(0, "Loading Plugin: " + bwp.getPluginName() + " | Phase: Init");
            bwp.init();
        }
    }

    @Mod.EventHandler
    public synchronized void postInit(FMLPostInitializationEvent event) {
        if (event.getSide().isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)new TooltipHandler());
        }
        for (BasePluginWitchery bwp : WitcheryExtras.getMpostinitevents()) {
            WitcheryExtras.log(0, "Loading Plugin: " + bwp.getPluginName() + " | Phase: Post-Init");
            bwp.postInit();
        }
        PredictionHandler.adjustPredictions();
    }

    public static void log(int level, String text) {
        if (level <= 0) {
            Logger.INFO(text);
        } else if (level == 1) {
            Logger.WARNING(text);
        } else {
            Logger.ERROR(text);
        }
    }

    public static synchronized Collection<BasePluginWitchery> getMpreinitevents() {
        return mPreInitEvents.values();
    }

    public static synchronized Collection<BasePluginWitchery> getMinitevents() {
        return mInitEvents.values();
    }

    public static synchronized Collection<BasePluginWitchery> getMpostinitevents() {
        return mPostInitEvents.values();
    }

    public static synchronized void addEventPreInit(BasePluginWitchery basePluginWitchery) {
        mPreInitEvents.put(mID_1++, basePluginWitchery);
    }

    public static synchronized void addEventInit(BasePluginWitchery minitevents) {
        mInitEvents.put(mID_2++, minitevents);
    }

    public static synchronized void addEventPostInit(BasePluginWitchery mpostinitevents) {
        mPostInitEvents.put(mID_3++, mpostinitevents);
    }

    static {
        mID_1 = 0;
        mID_2 = 0;
        mID_3 = 0;
    }
}

