/*
 * Decompiled with CFR 0.152.
 */
package adventurebackpack.api;

import com.darkona.adventurebackpack.fluids.FluidEffectRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public abstract class FluidEffect {
    public Fluid fluid;
    public int timeInSeconds;
    public int timeInTicks;
    public int effectID;

    public FluidEffect(Fluid fluid) {
        this(fluid, 5);
    }

    public FluidEffect(Fluid fluid, int timeInSeconds) {
        this.timeInSeconds = timeInSeconds;
        this.fluid = fluid;
        this.timeInTicks = this.timeInSeconds * 20;
        this.effectID = 0;
        if (fluid != null) {
            FluidEffectRegistry.registerFluidEffect(this);
        }
    }

    public FluidEffect(String fluidName, int timeInSeconds) {
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        this.timeInSeconds = timeInSeconds;
        this.fluid = fluid;
        this.timeInTicks = this.timeInSeconds * 20;
        this.effectID = 0;
        if (fluid != null) {
            FluidEffectRegistry.registerFluidEffect(this);
        }
    }

    public void setEffectID(int id) {
        this.effectID = id;
    }

    public int getEffectID() {
        return this.effectID;
    }

    public abstract void affectDrinker(World var1, Entity var2);
}

