/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.item;

import com.darkona.adventurebackpack.block.BlockAdventureBackpack;
import com.darkona.adventurebackpack.block.TileAdventureBackpack;
import com.darkona.adventurebackpack.common.BackpackAbilities;
import com.darkona.adventurebackpack.config.ConfigHandler;
import com.darkona.adventurebackpack.events.WearableEvent;
import com.darkona.adventurebackpack.init.ModBlocks;
import com.darkona.adventurebackpack.init.ModNetwork;
import com.darkona.adventurebackpack.item.ItemAdventure;
import com.darkona.adventurebackpack.network.GUIPacket;
import com.darkona.adventurebackpack.playerProperties.BackpackProperty;
import com.darkona.adventurebackpack.proxy.ClientProxy;
import com.darkona.adventurebackpack.reference.BackpackTypes;
import com.darkona.adventurebackpack.util.BackpackUtils;
import com.darkona.adventurebackpack.util.CoordsUtils;
import com.darkona.adventurebackpack.util.EnchUtils;
import com.darkona.adventurebackpack.util.Resources;
import com.darkona.adventurebackpack.util.TipUtils;
import com.darkona.adventurebackpack.util.Utils;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidTank;

public class ItemAdventureBackpack
extends ItemAdventure {
    public ItemAdventureBackpack() {
        this.func_77655_b("adventureBackpack");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List subItems) {
        for (BackpackTypes type : BackpackTypes.values()) {
            if (type == BackpackTypes.UNKNOWN) continue;
            subItems.add(BackpackUtils.createBackpackStack(type));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltips, boolean advanced) {
        NBTTagCompound backpackTag = BackpackUtils.getWearableCompound(stack);
        BackpackTypes type = BackpackTypes.getType(backpackTag.func_74771_c("type"));
        tooltips.add(Utils.getColoredSkinName(type));
        FluidTank tank = new FluidTank(4000);
        if (GuiScreen.func_146272_n()) {
            NBTTagList itemList = backpackTag.func_150295_c("inventory", 10);
            tooltips.add(TipUtils.l10n("backpack.slots.used") + ": " + TipUtils.inventoryTooltip(itemList));
            tank.readFromNBT(backpackTag.func_74775_l("leftTank"));
            tooltips.add(TipUtils.l10n("backpack.tank.left") + ": " + TipUtils.tankTooltip(tank));
            tank.readFromNBT(backpackTag.func_74775_l("rightTank"));
            tooltips.add(TipUtils.l10n("backpack.tank.right") + ": " + TipUtils.tankTooltip(tank));
            TipUtils.shiftFooter(tooltips);
        } else if (!GuiScreen.func_146271_m()) {
            tooltips.add(TipUtils.holdShift());
        }
        if (GuiScreen.func_146271_m()) {
            boolean cycling = !backpackTag.func_74767_n("disableCycling");
            tooltips.add(TipUtils.l10n("backpack.cycling") + ": " + TipUtils.switchTooltip(cycling, true));
            tooltips.add(TipUtils.pressKeyFormat(TipUtils.actionKeyFormat()) + TipUtils.l10n("backpack.cycling.key1"));
            tooltips.add(TipUtils.l10n("backpack.cycling.key2") + " " + TipUtils.switchTooltip(!cycling, false));
            if (BackpackTypes.isNightVision(type)) {
                boolean vision = !backpackTag.func_74767_n("disableNVision");
                tooltips.add(TipUtils.l10n("backpack.vision") + ": " + TipUtils.switchTooltip(vision, true));
                tooltips.add(TipUtils.pressShiftKeyFormat(TipUtils.actionKeyFormat()) + TipUtils.l10n("backpack.vision.key1"));
                tooltips.add(TipUtils.l10n("backpack.vision.key2") + " " + TipUtils.switchTooltip(!vision, false));
            }
        }
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        BackpackUtils.setBackpackType(stack, BackpackTypes.getType(stack.func_77960_j()));
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return player.func_82247_a(x, y, z, side, stack) && this.placeBackpack(stack, player, world, x, y, z, side, true);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        MovingObjectPosition mop = this.func_77621_a(world, player, true);
        if ((mop == null || mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) && world.field_72995_K) {
            ModNetwork.net.sendToServer((IMessage)new GUIPacket.GUImessage(1, 1));
        }
        return stack;
    }

    @Override
    public void onPlayerDeath(World world, EntityPlayer player, ItemStack stack) {
        if (world.field_72995_K || !ConfigHandler.backpackDeathPlace || EnchUtils.isSoulBounded(stack) || player.func_130014_f_().func_82736_K().func_82766_b("keepInventory")) {
            return;
        }
        if (!this.tryPlace(world, player, stack)) {
            player.func_71019_a(stack, false);
        }
        BackpackProperty.get(player).setWearable(null);
    }

    private boolean tryPlace(World world, EntityPlayer player, ItemStack backpack) {
        int[] positions;
        int Y;
        int X = (int)player.field_70165_t;
        if (player.field_70165_t < 0.0) {
            --X;
        }
        int Z = (int)player.field_70161_v;
        if (player.field_70161_v < 0.0) {
            --Z;
        }
        if ((Y = (int)player.field_70163_u) < 1) {
            Y = 1;
        }
        for (int shiftY : positions = new int[]{0, -1, 1, -2, 2, -3, 3, -4, 4, -5, 5, -6, 6}) {
            ChunkCoordinates spawn;
            if (Y + shiftY < 1 || (spawn = CoordsUtils.getNearestEmptyChunkCoordinatesSpiral((IBlockAccess)world, X, Z, X, Y + shiftY, Z, 6, true, 1, (byte)0, false)) == null) continue;
            return this.placeBackpack(backpack, player, world, spawn.field_71574_a, spawn.field_71572_b, spawn.field_71573_c, ForgeDirection.UP.ordinal(), false);
        }
        return false;
    }

    private boolean placeBackpack(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, boolean from) {
        if (stack.field_77994_a == 0 || !player.func_82247_a(x, y, z, side, stack)) {
            return false;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.field_77990_d.func_74764_b("type")) {
            stack.field_77990_d.func_74774_a("type", BackpackTypes.getMeta(BackpackTypes.STANDARD));
        }
        BlockAdventureBackpack backpack = ModBlocks.blockBackpack;
        if (y <= 0 || y >= world.func_72800_K()) {
            return false;
        }
        if (backpack.func_149707_d(world, x, y, z, side)) {
            if (world.func_147439_a(x, y, z).func_149688_o().func_76220_a()) {
                switch (side) {
                    case 0: {
                        --y;
                        break;
                    }
                    case 1: {
                        ++y;
                        break;
                    }
                    case 2: {
                        --z;
                        break;
                    }
                    case 3: {
                        ++z;
                        break;
                    }
                    case 4: {
                        --x;
                        break;
                    }
                    case 5: {
                        ++x;
                    }
                }
            }
            if (y <= 0 || y >= world.func_72800_K()) {
                return false;
            }
            if (backpack.func_149742_c(world, x, y, z) && world.func_147449_b(x, y, z, (Block)ModBlocks.blockBackpack)) {
                backpack.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
                world.func_72956_a((Entity)player, BlockAdventureBackpack.field_149775_l.func_150498_e(), 0.5f, 1.0f);
                ((TileAdventureBackpack)world.func_147438_o(x, y, z)).loadFromNBT(stack.field_77990_d);
                if (from) {
                    --stack.field_77994_a;
                } else {
                    BackpackProperty.get(player).setWearable(null);
                }
                WearableEvent event = new WearableEvent(player, stack);
                MinecraftForge.EVENT_BUS.post((Event)event);
                return true;
            }
        }
        return false;
    }

    @Override
    public void onEquipped(World world, EntityPlayer player, ItemStack stack) {
    }

    @Override
    public void onEquippedUpdate(World world, EntityPlayer player, ItemStack stack) {
        if (!ConfigHandler.backpackAbilities || world == null || player == null || stack == null) {
            return;
        }
        if (BackpackTypes.isSpecial(BackpackTypes.getType(stack))) {
            BackpackAbilities.backpackAbilities.executeAbility(player, world, stack);
        }
    }

    @Override
    public void onUnequipped(World world, EntityPlayer player, ItemStack stack) {
        if (BackpackTypes.hasProperty(BackpackTypes.getType(stack), BackpackTypes.Props.REMOVAL)) {
            BackpackAbilities.backpackAbilities.executeRemoval(player, world, stack);
        }
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)this.getItemCount(stack) / 48.0;
    }

    private int getItemCount(ItemStack backpack) {
        int slotAtI;
        NBTTagList itemList = BackpackUtils.getWearableInventory(backpack);
        int itemCount = itemList.func_74745_c();
        for (int i = itemCount - 1; i >= 0 && (slotAtI = itemList.func_150305_b(i).func_74762_e("Slot")) >= 48; --i) {
            --itemCount;
        }
        return itemCount;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ConfigHandler.enableFullnessBar && this.getItemCount(stack) > 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBiped getWearableModel(ItemStack wearable) {
        return ClientProxy.modelAdventureBackpack.setWearable(wearable);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getWearableTexture(ItemStack wearable) {
        return Resources.getBackpackTexture(BackpackTypes.getType(wearable));
    }
}

