/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.factory;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.eydamos.backpack.factory.FactoryBackpackNormal;
import de.eydamos.backpack.factory.FactoryPersonalSlot;
import de.eydamos.backpack.factory.FactoryWorkbenchBackpack;
import de.eydamos.backpack.gui.GuiAdvanced;
import de.eydamos.backpack.inventory.container.ContainerAdvanced;
import de.eydamos.backpack.saves.AbstractSave;
import de.eydamos.backpack.saves.BackpackSave;
import de.eydamos.backpack.saves.PlayerSave;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;

public class FactoryBackpack {
    public static <S extends AbstractSave> ContainerAdvanced getContainer(S save, IInventory[] inventories, EntityPlayer entityPlayer) {
        ContainerAdvanced containerAdvanced;
        byte type = save.getType();
        switch (type) {
            case 1: {
                containerAdvanced = new FactoryBackpackNormal().getContainer((BackpackSave)save, inventories, entityPlayer);
                break;
            }
            case 2: {
                containerAdvanced = new FactoryWorkbenchBackpack().getContainer((BackpackSave)save, inventories, entityPlayer);
                break;
            }
            case -1: {
                containerAdvanced = new FactoryPersonalSlot().getContainer((PlayerSave)save, inventories, entityPlayer);
                break;
            }
            default: {
                containerAdvanced = new ContainerAdvanced();
            }
        }
        return containerAdvanced;
    }

    @SideOnly(value=Side.CLIENT)
    public static <S extends AbstractSave> GuiContainer getGuiContainer(AbstractSave save, IInventory[] inventories, EntityPlayer entityPlayer) {
        GuiAdvanced guiAdvanced;
        byte type = save.getType();
        switch (type) {
            case 1: {
                guiAdvanced = new FactoryBackpackNormal().getGuiContainer((BackpackSave)save, inventories, entityPlayer);
                break;
            }
            case 2: {
                guiAdvanced = new FactoryWorkbenchBackpack().getGuiContainer((BackpackSave)save, inventories, entityPlayer);
                break;
            }
            case -1: {
                guiAdvanced = new FactoryPersonalSlot().getGuiContainer((PlayerSave)save, inventories, entityPlayer);
                break;
            }
            default: {
                guiAdvanced = new GuiAdvanced(FactoryBackpack.getContainer(save, inventories, entityPlayer));
            }
        }
        return guiAdvanced;
    }
}

