/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.api;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import cpw.mods.fml.common.FMLLog;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;

public class EnchantmentHelper {
    private static BitSet reservedId;
    private final TreeSet<Enchantment> enchants;
    public static final int MIN_FREE_SLOT = 8;
    public static final int INVALID = -1;

    public EnchantmentHelper() {
        this.enchants = Sets.newTreeSet((Comparator)new Comparator<Enchantment>(){

            @Override
            public int compare(Enchantment o1, Enchantment o2) {
                return o1.field_77352_x - o2.field_77352_x;
            }
        });
    }

    public EnchantmentHelper(Comparator<Enchantment> comparator) {
        this.enchants = Sets.newTreeSet(comparator);
    }

    public List<Enchantment> getEnchants() {
        return ImmutableList.copyOf(this.enchants);
    }

    public boolean addEnchantment(Enchantment enchantment) {
        return enchantment != null && this.enchants.add(enchantment);
    }

    public Collection<ItemStack> getEnchantmentBooks() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(this.enchants.size());
        for (Enchantment enchantment : this.enchants) {
            list.add(Items.field_151134_bR.func_92111_a(new EnchantmentData(enchantment, enchantment.func_77325_b())));
        }
        return list;
    }

    public static int getLowestAvailableId() {
        return EnchantmentHelper.getNextAvailableId(8);
    }

    public static int getNextAvailableId(int startingId) {
        int result;
        int n = result = startingId < 8 ? 8 : startingId;
        while (result < Enchantment.field_77331_b.length) {
            if (Enchantment.field_77331_b[result] == null) {
                return result;
            }
            ++result;
        }
        return -1;
    }

    public static int takeNextAvailableId(int startingId) {
        int temp;
        int result;
        if (reservedId == null) {
            reservedId = new BitSet(Enchantment.field_77331_b.length);
        }
        int n = result = startingId < 8 ? 8 : startingId;
        while ((temp = EnchantmentHelper.getNextAvailableId(result)) >= result) {
            result = temp;
            if (!reservedId.get(result)) {
                reservedId.set(result);
                return result;
            }
            if (++result < Enchantment.field_77331_b.length) continue;
        }
        return -1;
    }

    public static int takeNextAvailableId(Property property) {
        int start;
        if (property != null && property.isIntValue() && (start = property.getInt()) >= 0 && start < Enchantment.field_77331_b.length) {
            int result = EnchantmentHelper.takeNextAvailableId(start);
            property.set(result);
            return result;
        }
        return -1;
    }

    public static Optional<Enchantment> build(Property property, String name, Class<? extends Enchantment> type, Object ... args) {
        int id = EnchantmentHelper.takeNextAvailableId(property);
        if (id != -1 && type != null) {
            Enchantment enchantment = null;
            try {
                if (args != null) {
                    Class[] ctorArgClasses = new Class[args.length + 1];
                    ctorArgClasses[0] = Integer.TYPE;
                    for (int idx = 0; idx < args.length; ++idx) {
                        ctorArgClasses[idx + 1] = Primitives.unwrap(args[idx].getClass());
                    }
                    Constructor<? extends Enchantment> constructor = type.getConstructor(ctorArgClasses);
                    enchantment = constructor.newInstance(ObjectArrays.concat((Object)id, (Object[])args));
                } else {
                    Constructor<? extends Enchantment> constructor = type.getConstructor(Integer.TYPE);
                    enchantment = constructor.newInstance(id);
                }
            }
            catch (Exception logged) {
                FMLLog.log((Level)Level.ERROR, (Throwable)logged, (String)"Caught an exception during enchantment registration", (Object[])new Object[0]);
            }
            if (enchantment != null && name != null && !name.isEmpty()) {
                enchantment.func_77322_b(name);
            }
            return Optional.fromNullable(enchantment);
        }
        return Optional.absent();
    }

    public static int getId(Optional<Enchantment> enchantmentOptional) {
        if (enchantmentOptional.isPresent()) {
            return ((Enchantment)enchantmentOptional.get()).field_77352_x;
        }
        return -1;
    }

    public static int getEnchantmentLevel(Optional<Enchantment> enchantmentOptional, ItemStack itemStack) {
        if (enchantmentOptional.isPresent()) {
            return net.minecraft.enchantment.EnchantmentHelper.func_77506_a((int)((Enchantment)enchantmentOptional.get()).field_77352_x, (ItemStack)itemStack);
        }
        return 0;
    }
}

