/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.heraldry.tools;

import mods.battlegear2.client.heraldry.tools.RectangleTool;

public class CircleTool
extends RectangleTool {
    @Override
    public String getToolName() {
        return "tool.circle";
    }

    private void plotPoint(int x, int y, int[] pixels, int rgb) {
        if (x > -1 && x < 32 && y > -1 && y < 32) {
            pixels[x + 32 * y] = rgb;
        }
    }

    protected void drawShape2(int minX, int minY, int maxX, int maxY, int[] pixels, int rgb) {
        float x_mid = (float)(maxX + minX) / 2.0f;
        float y_mid = (float)(maxY + minY) / 2.0f;
        float x_rad = (float)(maxX - minX) / 2.0f;
        float y_rad = (float)(maxY - minY) / 2.0f;
        float time = 0.0f;
        while ((double)time < 1.5707963267948966) {
            this.plotPoint((int)Math.round((double)x_mid + (double)x_rad * Math.cos(time)), (int)Math.round((double)y_mid + (double)y_rad * Math.sin(time)), pixels, rgb);
            this.plotPoint((int)Math.round((double)x_mid - (double)x_rad * Math.cos(time)), (int)Math.round((double)y_mid + (double)y_rad * Math.sin(time)), pixels, rgb);
            this.plotPoint((int)Math.round((double)x_mid + (double)x_rad * Math.cos(time)), (int)Math.round((double)y_mid - (double)y_rad * Math.sin(time)), pixels, rgb);
            this.plotPoint((int)Math.round((double)x_mid - (double)x_rad * Math.cos(time)), (int)Math.round((double)y_mid - (double)y_rad * Math.sin(time)), pixels, rgb);
            time += 0.05f;
        }
    }

    @Override
    protected void drawShape(int minX, int minY, int maxX, int maxY, int[] pixels, int rgb) {
        float x_mid = (float)(maxX + minX) / 2.0f;
        float y_mid = (float)(maxY + minY) / 2.0f;
        float x_rad = (float)(maxX - minX) / 2.0f;
        float y_rad = (float)(maxY - minY) / 2.0f;
        float x_r_sq = x_rad * x_rad;
        int last_x = 0;
        float last_y = y_rad;
        int x = 1;
        while ((float)x <= x_rad) {
            float y = (float)((double)y_rad * Math.sqrt(x_r_sq - (float)(x * x)) / (double)x_rad);
            this.drawLine((int)Math.ceil(x_mid + (float)last_x), (int)Math.ceil(x_mid + (float)x), (int)Math.ceil(y_mid + last_y), (int)Math.ceil(y_mid + y), pixels, rgb);
            this.drawLine((int)Math.floor(x_mid - (float)last_x), (int)Math.floor(x_mid - (float)x), (int)Math.ceil(y_mid + last_y), (int)Math.ceil(y_mid + y), pixels, rgb);
            this.drawLine((int)Math.ceil(x_mid + (float)last_x), (int)Math.ceil(x_mid + (float)x), (int)Math.floor(y_mid - last_y), (int)Math.floor(y_mid - y), pixels, rgb);
            this.drawLine((int)Math.floor(x_mid - (float)last_x), (int)Math.floor(x_mid - (float)x), (int)Math.floor(y_mid - last_y), (int)Math.floor(y_mid - y), pixels, rgb);
            last_x = x++;
            last_y = y;
        }
        this.drawLine((int)Math.floor(x_mid - (float)last_x), (int)Math.floor(x_mid - (float)last_x), (int)Math.floor(y_mid - last_y), (int)Math.ceil(y_mid + last_y), pixels, rgb);
        this.drawLine((int)Math.ceil(x_mid + (float)last_x), (int)Math.ceil(x_mid + (float)last_x), (int)Math.floor(y_mid - last_y), (int)Math.ceil(y_mid + last_y), pixels, rgb);
    }

    private void drawLine(int x0, int x1, int y0, int y1, int[] pixelsCurrent, int rgb) {
        int dx = Math.abs(x1 - x0);
        int dy = Math.abs(y1 - y0);
        int sx = x0 < x1 ? 1 : -1;
        int sy = y0 < y1 ? 1 : -1;
        int err = dx - dy;
        boolean done = false;
        while (!done) {
            int e2;
            if (x0 > -1 && x0 < 32 && y0 > -1 && y0 < 32) {
                pixelsCurrent[x0 + 32 * y0] = rgb;
            }
            if (x0 == x1 && y0 == y1) {
                done = true;
            }
            if ((e2 = 2 * err) > -dy && !done) {
                err -= dy;
                x0 += sx;
            }
            if (x0 == x1 && y0 == y1 && !done) {
                if (x0 > -1 && x0 < 32 && y0 > -1 && y0 < 32) {
                    pixelsCurrent[x0 + 32 * y0] = rgb;
                }
                done = true;
            }
            if (e2 >= dx || done) continue;
            err += dx;
            y0 += sy;
        }
    }
}

