/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.gardening;

import binnie.botany.api.EnumAcidity;
import binnie.botany.api.EnumMoisture;
import binnie.botany.api.EnumSoilType;
import binnie.botany.gardening.BlockSoil;
import binnie.core.util.I18N;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class ItemSoil
extends ItemBlock {
    protected EnumSoilType type;
    private final boolean noWeed;

    public ItemSoil(Block block) {
        super(block);
        this.type = ((BlockSoil)this.field_150939_a).getType();
        this.noWeed = ((BlockSoil)this.field_150939_a).weedKilled;
        this.field_77787_bX = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, player, tooltip, advanced);
        EnumMoisture moisture = EnumMoisture.values()[stack.func_77960_j() % 3];
        EnumAcidity acidity = EnumAcidity.values()[stack.func_77960_j() / 3];
        String info = "";
        if (moisture == EnumMoisture.DRY) {
            info = info + EnumChatFormatting.YELLOW + I18N.localise("botany.moisture.dry") + EnumChatFormatting.RESET;
        }
        if (moisture == EnumMoisture.DAMP) {
            info = info + EnumChatFormatting.YELLOW + I18N.localise("botany.moisture.damp") + EnumChatFormatting.RESET;
        }
        if (acidity == EnumAcidity.ACID) {
            if (!info.isEmpty()) {
                info = info + ", ";
            }
            info = info + EnumChatFormatting.YELLOW + I18N.localise("botany.ph.acid") + EnumChatFormatting.RESET;
        }
        if (acidity == EnumAcidity.ALKALINE) {
            if (!info.isEmpty()) {
                info = info + ", ";
            }
            info = info + EnumChatFormatting.YELLOW + I18N.localise("botany.ph.alkaline") + EnumChatFormatting.RESET;
        }
        if (!info.isEmpty()) {
            tooltip.add(info);
        }
        if (this.noWeed) {
            tooltip.add(I18N.localise("botany.soil.weedkiller"));
        }
    }

    public String func_77653_i(ItemStack stack) {
        String soilName = this.type.name().toLowerCase(Locale.ENGLISH);
        return I18N.localise("botany.soil." + soilName);
    }

    public int func_77647_b(int meta) {
        return meta;
    }
}

