/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.database;

import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.ControlText;
import binnie.core.craftgui.controls.ControlTextCentered;
import binnie.core.craftgui.database.DatabaseTab;
import binnie.core.craftgui.database.PageBranch;
import binnie.core.util.I18N;
import forestry.api.genetics.IClassification;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;

public class PageBranchOverview
extends PageBranch {
    private final ControlText branchName;
    private final ControlText branchScientific;
    private final ControlText branchAuthority;
    private final List<ControlText> branchDescription = new ArrayList<ControlText>();

    public PageBranchOverview(IWidget parent, DatabaseTab tab) {
        super(parent, tab);
        this.branchName = new ControlTextCentered((IWidget)this, 8.0f, "");
        this.branchScientific = new ControlTextCentered((IWidget)this, 32.0f, "");
        this.branchAuthority = new ControlTextCentered((IWidget)this, 44.0f, "");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onValueChanged(IClassification branch) {
        void var4_6;
        String name = I18N.localise(branch.getName());
        this.branchName.setValue(EnumChatFormatting.BOLD + I18N.localise("binniecore.gui.database.branch.name", name) + EnumChatFormatting.RESET);
        this.branchScientific.setValue(EnumChatFormatting.ITALIC + I18N.localise("binniecore.gui.database.branch.apidae", branch.getScientific()) + EnumChatFormatting.RESET);
        this.branchAuthority.setValue(EnumChatFormatting.BOLD + I18N.localise("binniecore.gui.database.branch.discoveredBy", branch.getMemberSpecies()[0].getAuthority()) + EnumChatFormatting.RESET);
        for (IWidget iWidget : this.branchDescription) {
            this.deleteChild(iWidget);
        }
        this.branchDescription.clear();
        String desc = branch.getDescription();
        if (desc == null || desc.isEmpty() || desc.matches("(\\w+\\.?)+")) {
            desc = I18N.localise("binniecore.gui.database.branch.noDesc");
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> descLines = new ArrayList<String>();
        for (String str : desc.split(" ")) {
            if (CraftGUI.render.textWidth(var4_6 + " " + str) > 134) {
                descLines.add(EnumChatFormatting.ITALIC + var4_6.toString() + EnumChatFormatting.RESET);
                StringBuilder stringBuilder2 = new StringBuilder();
            }
            var4_6.append(" ").append(str);
        }
        descLines.add(var4_6.toString());
        int i = 0;
        for (String dLine : descLines) {
            this.branchDescription.add(new ControlTextCentered((IWidget)this, 84 + 12 * i++, dLine));
        }
    }
}

