/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.database;

import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.ControlTextEdit;
import binnie.core.craftgui.controls.listbox.ControlListBox;
import binnie.core.craftgui.controls.listbox.ControlTextOption;
import binnie.core.craftgui.controls.page.ControlPage;
import binnie.core.craftgui.controls.page.ControlPages;
import binnie.core.craftgui.controls.tab.ControlTab;
import binnie.core.craftgui.controls.tab.ControlTabBar;
import binnie.core.craftgui.database.ControlBranchBox;
import binnie.core.craftgui.database.ControlSpeciesBox;
import binnie.core.craftgui.database.DatabaseTab;
import binnie.core.craftgui.database.IDatabaseMode;
import binnie.core.craftgui.database.PageAbstract;
import binnie.core.craftgui.events.EventHandler;
import binnie.core.craftgui.events.EventTextEdit;
import binnie.core.craftgui.events.EventValueChanged;
import binnie.core.craftgui.geometry.CraftGUIUtil;
import binnie.core.craftgui.geometry.IArea;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.geometry.Position;
import binnie.core.craftgui.minecraft.MinecraftGUI;
import binnie.core.craftgui.minecraft.Window;
import binnie.core.craftgui.minecraft.control.ControlHelp;
import binnie.core.craftgui.window.Panel;
import binnie.core.genetics.BreedingSystem;
import binnie.core.util.I18N;
import binnie.core.util.IValidator;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IClassification;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;

public abstract class WindowAbstractDatabase
extends Window {
    protected boolean isNEI;
    private float selectionBoxWidth = 95.0f;
    private final Map<IDatabaseMode, ModeWidgets> modes = new HashMap<IDatabaseMode, ModeWidgets>();
    private final BreedingSystem system;
    private Panel panelInformation;
    private Panel panelSearch;
    private ControlPages<IDatabaseMode> modePages;
    private IAlleleSpecies gotoSpecies;

    public void changeMode(IDatabaseMode mode) {
        this.modePages.setValue(mode);
    }

    public WindowAbstractDatabase(EntityPlayer player, Side side, boolean nei, BreedingSystem system, float wid) {
        super(100.0f, 192.0f, player, null, side);
        this.isNEI = nei;
        this.system = system;
        this.selectionBoxWidth = wid;
    }

    public ControlPages<DatabaseTab> getInfoPages(IDatabaseMode mode) {
        return this.modes.get(mode).infoPages;
    }

    public boolean isNEI() {
        return this.isNEI;
    }

    public BreedingSystem getBreedingSystem() {
        return this.system;
    }

    public WindowAbstractDatabase(EntityPlayer player, Side side, boolean nei, BreedingSystem system) {
        this(player, side, nei, system, 95.0f);
    }

    protected ModeWidgets createMode(IDatabaseMode mode, ModeWidgets widgets) {
        this.modes.put(mode, widgets);
        return widgets;
    }

    @Override
    public void initialiseClient() {
        this.setSize(new IPoint(176.0f + this.selectionBoxWidth + 22.0f + 8.0f, 208.0f));
        this.addEventHandler((EventHandler)new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                IWidget iWidget = event.getOrigin().getParent();
                if (!(iWidget instanceof ControlPage)) {
                    return;
                }
                ControlPage parent = (ControlPage)iWidget;
                if (event.getValue() instanceof DatabaseTab) {
                    return;
                }
                if (!(parent.getValue() instanceof IDatabaseMode)) {
                    return;
                }
                for (IWidget widget : parent.getWidgets()) {
                    if (!(widget instanceof ControlPages)) continue;
                    if (event.getValue() == null) {
                        widget.hide();
                        continue;
                    }
                    widget.show();
                    for (IWidget widget2 : widget.getWidgets()) {
                        if (!(widget2 instanceof PageAbstract)) continue;
                        ((PageAbstract)widget2).onValueChanged(event.getValue());
                    }
                }
            }
        });
        this.addEventHandler(new EventTextEdit.Handler(){

            @Override
            public void onEvent(final EventTextEdit event) {
                for (ModeWidgets widgets : WindowAbstractDatabase.this.modes.values()) {
                    widgets.listBox.setValidator(new IValidator<IWidget>(){

                        @Override
                        public boolean isValid(IWidget object) {
                            return ((String)event.getValue()).isEmpty() || ((ControlTextOption)object).getText().toLowerCase().contains(((String)event.getValue()).toLowerCase());
                        }
                    });
                }
            }
        }.setOrigin(EventHandler.Origin.DirectChild, this));
        new ControlHelp(this, 4.0f, 4.0f);
        this.panelInformation = new Panel(this, 24.0f, 24.0f, 144.0f, 176.0f, MinecraftGUI.PanelType.Black);
        this.panelInformation.setColor(860416);
        this.panelSearch = new Panel(this, 176.0f, 24.0f, this.selectionBoxWidth, 160.0f, MinecraftGUI.PanelType.Black);
        this.panelSearch.setColor(860416);
        this.modePages = new ControlPages(this, 0.0f, 0.0f, this.getSize().x(), this.getSize().y());
        new ControlTextEdit(this, 176.0f, 184.0f, this.selectionBoxWidth, 16.0f);
        this.createMode(Mode.Species, new ModeWidgets(Mode.Species, this){

            @Override
            public void createListBox(IArea area) {
                GameProfile playerName = WindowAbstractDatabase.this.getUsername();
                Collection<IAlleleSpecies> speciesList = this.database.isNEI ? this.database.system.getAllSpecies() : this.database.system.getDiscoveredSpecies(this.database.getWorld(), playerName);
                this.listBox = new ControlSpeciesBox(this.modePage, area.x(), area.y(), area.w(), area.h());
                this.listBox.setOptions(speciesList);
            }
        });
        this.createMode(Mode.Branches, new ModeWidgets(Mode.Branches, this){

            @Override
            public void createListBox(IArea area) {
                GameProfile playerName = WindowAbstractDatabase.this.getUsername();
                List<IClassification> speciesList = this.database.isNEI ? this.database.system.getAllBranches() : this.database.system.getDiscoveredBranches(this.database.getWorld(), playerName);
                this.listBox = new ControlBranchBox(this.modePage, area.x(), area.y(), area.w(), area.h());
                this.listBox.setOptions(speciesList);
            }
        });
        this.createMode(Mode.Breeder, new ModeWidgets(Mode.Breeder, this){

            @Override
            public void createListBox(IArea area) {
                this.listBox = new ControlListBox(this.modePage, area.x(), area.y(), area.w(), area.h(), 12.0f);
            }
        });
        this.addTabs();
        ControlTabBar<IDatabaseMode> tab = new ControlTabBar<IDatabaseMode>((IWidget)this, 176.0f + this.selectionBoxWidth, 24.0f, 22.0f, 176.0f, Position.RIGHT){

            @Override
            public ControlTab<IDatabaseMode> createTab(float x, float y, float w, float h, IDatabaseMode value) {
                return new ControlTab<IDatabaseMode>((ControlTabBar)this, x, y, w, h, value){

                    @Override
                    public String getName() {
                        return ((IDatabaseMode)this.value).getName();
                    }
                };
            }
        };
        tab.setValues(this.modePages.getValues());
        CraftGUIUtil.linkWidgets(tab, this.modePages);
        this.changeMode(Mode.Species);
        for (IDatabaseMode mode : this.modes.keySet()) {
            this.modes.get(mode).infoTabs = new ControlTabBar(this.modes.get((Object)mode).modePage, 8.0f, 24.0f, 16.0f, 176.0f, Position.LEFT);
            this.modes.get(mode).infoTabs.setValues(this.modes.get(mode).infoPages.getValues());
            CraftGUIUtil.linkWidgets(this.modes.get(mode).infoTabs, this.modes.get(mode).infoPages);
        }
    }

    @Override
    public void initialiseServer() {
        IBreedingTracker tracker = this.system.getSpeciesRoot().getBreedingTracker(this.getWorld(), this.getUsername());
        if (tracker != null) {
            tracker.synchToPlayer(this.getPlayer());
        }
    }

    protected void addTabs() {
    }

    public void gotoSpecies(IAlleleSpecies value) {
        if (value == null) {
            return;
        }
        this.modePages.setValue(Mode.Species);
        this.changeMode(Mode.Species);
        this.modes.get((Object)this.modePages.getValue()).listBox.setValue(value);
    }

    public void gotoSpeciesDelayed(IAlleleSpecies species) {
        this.gotoSpecies = species;
    }

    @Override
    public void onUpdateClient() {
        super.onUpdateClient();
        if (this.gotoSpecies == null) {
            return;
        }
        ((WindowAbstractDatabase)this.getSuperParent()).gotoSpecies(this.gotoSpecies);
        this.gotoSpecies = null;
    }

    public static abstract class ModeWidgets {
        public WindowAbstractDatabase database;
        public ControlPage<IDatabaseMode> modePage;
        public ControlListBox listBox;
        private final ControlPages<DatabaseTab> infoPages;
        private ControlTabBar<DatabaseTab> infoTabs;

        public ModeWidgets(IDatabaseMode mode, WindowAbstractDatabase database) {
            this.database = database;
            this.modePage = new ControlPage<IDatabaseMode>(database.modePages, 0.0f, 0.0f, database.getSize().x(), database.getSize().y(), mode);
            IArea listBoxArea = database.panelSearch.area().inset(2);
            this.createListBox(listBoxArea);
            CraftGUIUtil.alignToWidget(this.listBox, database.panelSearch);
            CraftGUIUtil.moveWidget(this.listBox, new IPoint(2.0f, 2.0f));
            this.infoPages = new ControlPages(this.modePage, 0.0f, 0.0f, 144.0f, 176.0f);
            CraftGUIUtil.alignToWidget(this.infoPages, database.panelInformation);
        }

        public abstract void createListBox(IArea var1);
    }

    public static enum Mode implements IDatabaseMode
    {
        Species,
        Branches,
        Breeder;


        @Override
        public String getName() {
            return I18N.localise("binniecore.gui.database.mode." + this.name().toLowerCase());
        }
    }
}

