/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.minecraft.control;

import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.ITooltip;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.WidgetAttribute;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.minecraft.CustomSlot;
import binnie.core.craftgui.minecraft.MinecraftTooltip;
import binnie.core.craftgui.minecraft.Window;
import binnie.core.craftgui.minecraft.control.ControlEnergyBar;
import binnie.core.craftgui.minecraft.control.ControlLiquidTank;
import binnie.core.craftgui.minecraft.control.ControlSlot;
import binnie.core.craftgui.minecraft.control.EnumHighlighting;
import binnie.core.craftgui.resource.minecraft.CraftGUITexture;
import binnie.core.machines.power.ErrorState;
import net.minecraft.entity.player.InventoryPlayer;

public class ControlErrorState
extends Control
implements ITooltip {
    private ErrorState errorState;
    private int type = 0;

    public ControlErrorState(IWidget parent, float x, float y) {
        super(parent, x, y, 16.0f, 16.0f);
        this.addAttribute(WidgetAttribute.MOUSE_OVER);
    }

    @Override
    public void onRenderBackground() {
        CraftGUITexture texture = CraftGUITexture.StateWarning;
        if (this.errorState == null) {
            texture = CraftGUITexture.StateNone;
        } else if (this.type == 0) {
            texture = CraftGUITexture.StateError;
        }
        CraftGUI.render.texture((Object)texture, IPoint.ZERO);
        super.onRenderBackground();
    }

    public ErrorState getError() {
        return ((Window)Window.get(this)).getContainer().getErrorState();
    }

    @Override
    public void onUpdateClient() {
        this.errorState = this.getError();
        this.type = ((Window)Window.get(this)).getContainer().getErrorType();
        ControlSlot.highlighting.get((Object)EnumHighlighting.ERROR).clear();
        ControlSlot.highlighting.get((Object)EnumHighlighting.WARNING).clear();
        ControlLiquidTank.tankError.clear();
        ControlEnergyBar.isError = false;
        if (!this.isMouseOver() || this.errorState == null) {
            return;
        }
        ControlEnergyBar.isError = this.errorState.isPowerError();
        if (this.errorState.isItemError()) {
            for (int slot : this.errorState.getData()) {
                int id = -1;
                for (CustomSlot cslot : ((Window)Window.get(this)).getContainer().getCustomSlots()) {
                    if (cslot.field_75224_c instanceof InventoryPlayer || cslot.getSlotIndex() != slot) continue;
                    id = cslot.field_75222_d;
                }
                if (id < 0) continue;
                if (this.type == 0) {
                    ControlSlot.highlighting.get((Object)EnumHighlighting.ERROR).add(id);
                    continue;
                }
                ControlSlot.highlighting.get((Object)EnumHighlighting.WARNING).add(id);
            }
        }
        if (this.errorState.isTankError()) {
            for (int slot : this.errorState.getData()) {
                ControlLiquidTank.tankError.add(slot);
            }
        }
    }

    @Override
    public void getTooltip(Tooltip tooltipOrig) {
        MinecraftTooltip tooltip = (MinecraftTooltip)tooltipOrig;
        if (this.errorState == null) {
            return;
        }
        if (this.type == 0) {
            tooltip.setType(MinecraftTooltip.Type.ERROR);
        } else {
            tooltip.setType(MinecraftTooltip.Type.WARNING);
        }
        tooltip.add(this.errorState.toString());
        if (!this.errorState.getTooltip().isEmpty()) {
            tooltip.add(this.errorState.getTooltip());
        }
    }
}

