/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import net.minecraft.util.MathHelper;

public enum Tolerance {
    None(0, 0),
    Both1(-1, 1),
    Both2(-2, 2),
    Both3(-3, 3),
    Both4(-4, 4),
    Both5(-5, 5),
    Up1(0, 1),
    Up2(0, 2),
    Up3(0, 3),
    Up4(0, 4),
    Up5(0, 5),
    Down1(-1, 0),
    Down2(-2, 0),
    Down3(-3, 0),
    Down4(-4, 0),
    Down5(-5, 0);

    private final int[] bounds;
    private static final Tolerance[] VALUES;

    private Tolerance(int a, int b) {
        this.bounds = new int[]{a, b};
    }

    public String getUID() {
        return "forestry.tolerance" + (Object)((Object)this);
    }

    public int[] getBounds() {
        return this.bounds;
    }

    public static Tolerance get(EnumTolerance tol) {
        return VALUES[tol.ordinal()];
    }

    public static Tolerance getHigh(int i) {
        Tolerance tolerance;
        switch (MathHelper.func_76125_a((int)i, (int)0, (int)5)) {
            case 0: {
                tolerance = None;
                break;
            }
            case 1: {
                tolerance = Up1;
                break;
            }
            case 2: {
                tolerance = Up2;
                break;
            }
            case 3: {
                tolerance = Up3;
                break;
            }
            case 4: {
                tolerance = Up4;
                break;
            }
            default: {
                tolerance = Up5;
            }
        }
        return tolerance;
    }

    public static Tolerance getLow(int i) {
        Tolerance tolerance;
        switch (MathHelper.func_76125_a((int)i, (int)-5, (int)0)) {
            case 0: {
                tolerance = None;
                break;
            }
            case -1: {
                tolerance = Down1;
                break;
            }
            case -2: {
                tolerance = Down2;
                break;
            }
            case -3: {
                tolerance = Down3;
                break;
            }
            case -4: {
                tolerance = Down4;
                break;
            }
            default: {
                tolerance = Down5;
            }
        }
        return tolerance;
    }

    public static Tolerance getBoth(int i) {
        Tolerance tolerance;
        switch (MathHelper.func_76125_a((int)i, (int)0, (int)5)) {
            case 0: {
                tolerance = None;
                break;
            }
            case 1: {
                tolerance = Both1;
                break;
            }
            case 2: {
                tolerance = Both2;
                break;
            }
            case 3: {
                tolerance = Both3;
                break;
            }
            case 4: {
                tolerance = Both4;
                break;
            }
            default: {
                tolerance = Both5;
            }
        }
        return tolerance;
    }

    public IAllele getAllele() {
        return AlleleManager.alleleRegistry.getAllele(this.getUID());
    }

    public <T extends Enum<T>> boolean canTolerate(T base, T test) {
        return test.ordinal() <= base.ordinal() + this.bounds[1] && test.ordinal() >= base.ordinal() + this.bounds[0];
    }

    public static <T extends Enum<T>> boolean canTolerate(T base, T test, EnumTolerance tol) {
        return Tolerance.get(tol).canTolerate(base, test);
    }

    static {
        VALUES = Tolerance.values();
    }
}

