/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines;

import binnie.core.machines.Machine;
import binnie.core.machines.MachineGroup;
import binnie.core.util.I18N;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.tileentity.TileEntity;

public abstract class MachinePackage {
    private final String uid;
    private boolean active = true;
    boolean powered;
    private int metadata = -1;
    private MachineGroup group;

    public String getUID() {
        return this.uid;
    }

    protected MachinePackage(String uid, boolean powered) {
        this.uid = uid;
        this.powered = powered;
    }

    public abstract void createMachine(Machine var1);

    public abstract TileEntity createTileEntity();

    public String getDisplayName() {
        return I18N.localise(this.group.getMod().getModID() + ".machine." + this.group.getShortUID() + "." + this.getUID());
    }

    public Integer getMetadata() {
        return this.metadata;
    }

    public void assignMetadata(int meta) {
        this.metadata = meta;
    }

    public MachineGroup getGroup() {
        return this.group;
    }

    public void setGroup(MachineGroup group) {
        this.group = group;
    }

    public abstract void renderMachine(Machine var1, double var2, double var4, double var6, float var8, RenderBlocks var9);

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getInformation() {
        return I18N.localise(this.group.getMod().getModID() + ".machine." + this.group.getShortUID() + "." + this.getUID() + ".info");
    }
}

