/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.products;

import binnie.core.item.IItemEnum;
import binnie.core.util.I18N;
import binnie.extrabees.ExtraBees;
import forestry.api.recipes.RecipeManagers;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.item.ItemStack;

public enum EnumHoneyComb implements IItemEnum
{
    BARREN(new Color(7564356), new Color(12762791)),
    ROTTEN(new Color(4084257), new Color(11652233)),
    BONE(new Color(12895407), new Color(14606017)),
    OIL(new Color(394760), new Color(2894646)),
    COAL(new Color(10392696), new Color(3682590)),
    FUEL(new Color(10252096), new Color(16761856)),
    WATER(new Color(2568911), new Color(7973065)),
    MILK(new Color(14145991), new Color(0xFFFFFF)),
    FRUIT(new Color(8202548), new Color(14372706)),
    SEED(new Color(0x344F33), new Color(7457902)),
    ALCOHOL(new Color(4293921), new Color(14604622)),
    STONE(new Color(9211025), new Color(0xC6C6CC)),
    REDSTONE(new Color(16422550), new Color(15077392)),
    RESIN(new Color(16762703), new Color(13208064)),
    IC2ENERGY(new Color(15332623), new Color(2143177)),
    IRON(new Color(3552564), new Color(11038808)),
    GOLD(new Color(3552564), new Color(15125515)),
    COPPER(new Color(3552564), new Color(13722376)),
    TIN(new Color(3552564), new Color(0xBDB1BD)),
    SILVER(new Color(3552564), new Color(0xDBDBDB)),
    URANIUM(new Color(2031360), new Color(4303667)),
    CLAY(new Color(7034426), new Color(11583702)),
    OLD(new Color(4535060), new Color(11769444)),
    FUNGAL(new Color(7234891), new Color(2856003)),
    CREOSOTE(new Color(10256652), new Color(12429911)),
    LATEX(new Color(5854529), new Color(11051653)),
    ACIDIC(new Color(3441987), new Color(1374014)),
    VENOMOUS(new Color(8198269), new Color(0xFF33FF)),
    SLIME(new Color(3884860), new Color(8442245)),
    BLAZE(new Color(16738816), new Color(0xFFCC00)),
    COFFEE(new Color(5519389), new Color(11763531)),
    GLACIAL(new Color(5146503), new Color(13366002)),
    SHADOW(new Color(0), new Color(3545141)),
    LEAD(new Color(3552564), new Color(10125468)),
    ZINC(new Color(3552564), new Color(15592447)),
    TITANIUM(new Color(3552564), new Color(11578083)),
    TUNGSTEN(new Color(3552564), new Color(1249812)),
    PLATINUM(new Color(3552564), new Color(10125468)),
    LAPIS(new Color(3552564), new Color(4009179)),
    EMERALD(new Color(3552564), new Color(1900291)),
    RUBY(new Color(3552564), new Color(0xD60000)),
    SAPPHIRE(new Color(3552564), new Color(673791)),
    DIAMOND(new Color(3552564), new Color(8371706)),
    RED(new Color(0xCC4C4C), new Color(0xFF0000)),
    YELLOW(new Color(0xE5E533), new Color(0xFFDD00)),
    BLUE(new Color(10072818), new Color(8959)),
    GREEN(new Color(6717235), new Color(39168)),
    BLACK(new Color(0x191919), new Color(0x575757)),
    WHITE(new Color(0xD6D6D6), new Color(0xFFFFFF)),
    BROWN(new Color(8349260), new Color(6042895)),
    ORANGE(new Color(15905331), new Color(16751872)),
    CYAN(new Color(5020082), new Color(65509)),
    PURPLE(new Color(11691749), new Color(11403519)),
    GRAY(new Color(0x4C4C4C), new Color(0xBABABA)),
    LIGHTBLUE(new Color(10072818), new Color(40447)),
    PINK(new Color(15905484), new Color(16744671)),
    LIMEGREEN(new Color(8375321), new Color(65288)),
    MAGENTA(new Color(15040472), new Color(0xFF00CC)),
    LIGHTGRAY(new Color(0x999999), new Color(0xC9C9C9)),
    NICKEL(new Color(3552564), new Color(16768764)),
    GLOWSTONE(new Color(10919006), new Color(14730249)),
    SALTPETER(new Color(10919006), new Color(14730249)),
    COMPOST(new Color(4338440), new Color(7036475)),
    SAWDUST(new Color(12561009), new Color(15913854)),
    CERTUS(new Color(13029631), new Color(3755363)),
    ENDERPEARL(new Color(3446662), new Color(206368)),
    YELLORIUM(new Color(2564173), new Color(14019840)),
    CYANITE(new Color(2564173), new Color(34541)),
    BLUTONIUM(new Color(2564173), new Color(1769702));

    public final Map<ItemStack, Float> products;
    public final int primaryColor;
    public final int secondaryColor;
    public final String name;
    boolean active;

    private EnumHoneyComb(Color primaryColor, Color secondaryColor) {
        this.primaryColor = primaryColor.getRGB();
        this.secondaryColor = secondaryColor.getRGB();
        this.name = this.toString().toLowerCase(Locale.ENGLISH);
        this.products = new LinkedHashMap<ItemStack, Float>();
    }

    public static EnumHoneyComb get(ItemStack itemStack) {
        int i = itemStack.func_77960_j();
        if (i >= 0 && i < EnumHoneyComb.values().length) {
            return EnumHoneyComb.values()[i];
        }
        return EnumHoneyComb.values()[0];
    }

    public void addRecipe() {
        RecipeManagers.centrifugeManager.addRecipe(20, this.get(1), this.products);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public ItemStack get(int count) {
        return new ItemStack(ExtraBees.comb, count, this.ordinal());
    }

    @Override
    public String getName(ItemStack stack) {
        return I18N.localise("extrabees.item.comb." + this.name);
    }

    public boolean addProduct(ItemStack item, Float chance) {
        if (item == null) {
            return false;
        }
        this.products.put(item.func_77946_l(), chance);
        return true;
    }

    public void tryAddProduct(ItemStack item, Float chance) {
        this.active = this.addProduct(item, chance);
    }

    public void tryAddProduct(IItemEnum type, Float chance) {
        this.tryAddProduct(type.get(1), chance);
        this.active = this.active && type.isActive();
    }

    public void copyProducts(EnumHoneyComb comb) {
        this.products.putAll(comb.products);
    }
}

