/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.craftgui;

import binnie.Binnie;
import binnie.core.AbstractMod;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.controls.ControlText;
import binnie.core.craftgui.controls.ControlTextEdit;
import binnie.core.craftgui.controls.scroll.ControlScrollableContent;
import binnie.core.craftgui.controls.tab.ControlTab;
import binnie.core.craftgui.controls.tab.ControlTabBar;
import binnie.core.craftgui.events.EventHandler;
import binnie.core.craftgui.events.EventTextEdit;
import binnie.core.craftgui.events.EventValueChanged;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.geometry.Position;
import binnie.core.craftgui.minecraft.MinecraftGUI;
import binnie.core.craftgui.minecraft.Window;
import binnie.core.craftgui.minecraft.control.ControlPlayerInventory;
import binnie.core.craftgui.minecraft.control.ControlTabIcon;
import binnie.core.craftgui.window.Panel;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.Gene;
import binnie.core.util.I18N;
import binnie.genetics.Genetics;
import binnie.genetics.craftgui.ControlGeneScroll;
import binnie.genetics.craftgui.WindowMachine;
import binnie.genetics.genetics.Engineering;
import binnie.genetics.genetics.GeneTracker;
import cpw.mods.fml.relauncher.Side;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class WindowGeneBank
extends WindowMachine {
    public boolean isNei;
    protected ControlGeneScroll genes;

    public WindowGeneBank(EntityPlayer player, IInventory inventory, Side side, boolean isNEI) {
        super(400, 224, player, inventory, side);
        this.isNei = isNEI;
    }

    public static Window create(EntityPlayer player, IInventory inventory, Side side) {
        return new WindowGeneBank(player, inventory, side, false);
    }

    @Override
    public void receiveGuiNBT(Side side, EntityPlayer player, String name, NBTTagCompound nbt) {
        super.receiveGuiNBT(side, player, name, nbt);
        if (side != Side.SERVER || !name.equals("gene-select")) {
            return;
        }
        Gene gene = new Gene(nbt.func_74775_l("gene"));
        if (gene.isCorrupted()) {
            return;
        }
        ItemStack held = this.getHeldItemStack();
        ItemStack converted = Engineering.addGene(held, gene);
        this.getPlayer().field_71071_by.func_70437_b(converted);
        this.getPlayer().field_71071_by.func_70296_d();
        if (this.getPlayer() instanceof EntityPlayerMP) {
            ((EntityPlayerMP)this.getPlayer()).func_71120_a(player.field_71069_bz);
        }
    }

    @Override
    public void initialiseServer() {
        GeneTracker tracker = GeneTracker.getTracker(this.getWorld(), this.getUsername());
        tracker.synchToPlayer(this.getPlayer());
    }

    @Override
    public void initialiseClient() {
        this.setTitle(this.getTitle());
        this.addEventHandler((EventHandler)new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                if (event.value instanceof BreedingSystem) {
                    WindowGeneBank.this.genes.setValue((BreedingSystem)event.value);
                }
            }
        });
        int x = 16;
        int y = 32;
        new ControlPlayerInventory(this, x, y).createAndRegister();
        int boxX = x += 124;
        int geneBoxWidth = 200;
        new Panel(this, boxX + 24, 32.0f, geneBoxWidth, 120.0f, MinecraftGUI.PanelType.Black);
        new Panel(this, boxX + 24 + geneBoxWidth, 32.0f, 14.0f, 120.0f, MinecraftGUI.PanelType.Gray);
        ControlScrollableContent<ControlGeneScroll> scroll = new ControlScrollableContent<ControlGeneScroll>(this, boxX + 24 + 2, 34.0f, geneBoxWidth + 10, 116.0f, 12.0f);
        ControlTextEdit edit = new ControlTextEdit(this, boxX + 27 + geneBoxWidth - 70, 18.0f, 80.0f, 12.0f);
        this.addEventHandler(new EventTextEdit.Handler(){

            @Override
            public void onEvent(EventTextEdit event) {
                WindowGeneBank.this.genes.setFilter((String)event.getValue());
            }
        }.setOrigin(EventHandler.Origin.Self, edit));
        this.genes = new ControlGeneScroll(scroll, 1.0f, 1.0f, geneBoxWidth, 116.0f);
        scroll.setScrollableContent(this.genes);
        this.genes.setGenes(Binnie.Genetics.beeBreedingSystem);
        ControlTabBar<BreedingSystem> tabBar = new ControlTabBar<BreedingSystem>((IWidget)this, (float)boxX, 32.0f, 24.0f, 120.0f, Position.LEFT){

            @Override
            public ControlTab<BreedingSystem> createTab(float x, float y, float w, float h, BreedingSystem value) {
                return new ControlTabIcon<BreedingSystem>((ControlTabBar)this, x, y, w, h, value){

                    @Override
                    public void getTooltip(Tooltip tooltip) {
                        tooltip.add(((BreedingSystem)this.getValue()).toString());
                        int totalGenes = 0;
                        int seqGenes = 0;
                        GeneTracker tracker = GeneTracker.getTracker(WindowGeneBank.this.getWorld(), WindowGeneBank.this.getUsername());
                        Map<IChromosomeType, List<IAllele>> genes = Binnie.Genetics.getChromosomeMap(((BreedingSystem)this.getValue()).getSpeciesRoot());
                        for (Map.Entry<IChromosomeType, List<IAllele>> entry : genes.entrySet()) {
                            totalGenes += entry.getValue().size();
                            for (IAllele allele : entry.getValue()) {
                                Gene gene = new Gene(allele, entry.getKey(), ((BreedingSystem)this.getValue()).getSpeciesRoot());
                                if (!tracker.isSequenced(gene)) continue;
                                ++seqGenes;
                            }
                        }
                        tooltip.add(I18N.localise("genetics.gui.geneBank.sequencedGenes.short", seqGenes, totalGenes));
                    }
                };
            }
        };
        tabBar.setValues(Binnie.Genetics.getActiveSystems());
        tabBar.setValue(Binnie.Genetics.beeBreedingSystem);
        ControlTabBar<String> infoTabs = new ControlTabBar<String>(this, (boxX -= 8) + 8, 160.0f, 16.0f, 50.0f, Position.LEFT);
        infoTabs.setValues(Arrays.asList(I18N.localise("genetics.gui.geneBank.stats"), I18N.localise("genetics.gui.geneBank.ranking")));
        infoTabs.setValue(I18N.localise("genetics.gui.geneBank.info"));
        Panel panelProject = new Panel(this, boxX + 24, 160.0f, geneBoxWidth + 20, 50.0f, MinecraftGUI.PanelType.Black);
        int totalGenes = 0;
        int seqGenes = 0;
        for (BreedingSystem system : Binnie.Genetics.getActiveSystems()) {
            GeneTracker tracker = GeneTracker.getTracker(this.getWorld(), this.getUsername());
            Map<IChromosomeType, List<IAllele>> genes = Binnie.Genetics.getChromosomeMap(system.getSpeciesRoot());
            for (Map.Entry<IChromosomeType, List<IAllele>> entry : genes.entrySet()) {
                totalGenes += entry.getValue().size();
                for (IAllele allele : entry.getValue()) {
                    Gene gene = new Gene(allele, entry.getKey(), system.getSpeciesRoot());
                    if (!tracker.isSequenced(gene)) continue;
                    ++seqGenes;
                }
            }
        }
        new ControlText((IWidget)panelProject, new IPoint(4.0f, 4.0f), EnumChatFormatting.UNDERLINE + I18N.localise("genetics.gui.geneBank.project"));
        new ControlText((IWidget)panelProject, new IPoint(4.0f, 18.0f), EnumChatFormatting.ITALIC.toString() + EnumChatFormatting.YELLOW + I18N.localise("genetics.gui.geneBank.sequencedGenes", seqGenes, totalGenes));
    }

    @Override
    public String getTitle() {
        return I18N.localise("genetics.gui.geneBank");
    }

    @Override
    protected AbstractMod getMod() {
        return Genetics.instance;
    }

    @Override
    protected String getName() {
        return "GeneBank";
    }
}

