/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui;

import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.ControlTextCentered;
import binnie.core.craftgui.geometry.IArea;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.minecraft.control.ControlIconDisplay;
import binnie.core.craftgui.minecraft.control.ControlItemDisplay;
import binnie.core.util.I18N;
import binnie.core.util.UniqueItemStackSet;
import binnie.extratrees.FakeWorld;
import binnie.genetics.gui.AnalystPageProduce;
import binnie.genetics.item.ModuleItem;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IChromosomeType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class AnalystPageWood
extends AnalystPageProduce {
    public AnalystPageWood(IWidget parent, IArea area, ITree ind) {
        super(parent, area);
        this.setColor(0x663300);
        ITreeGenome genome = ind.getGenome();
        int y = 4;
        new ControlTextCentered((IWidget)this, y, EnumChatFormatting.UNDERLINE + this.getTitle()).setColor(this.getColor());
        y += 12;
        if (((IAlleleBoolean)ind.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.FIREPROOF)).getValue()) {
            new ControlIconDisplay(this, (this.w() - 16.0f) / 2.0f, y, ModuleItem.iconNoFire.getIcon()).addTooltip(I18N.localise("genetics.gui.analyst.wood.fireproof"));
        } else {
            new ControlIconDisplay(this, (this.w() - 16.0f) / 2.0f, y, ModuleItem.iconFire.getIcon()).addTooltip(I18N.localise("genetics.gui.analyst.wood.flammable"));
        }
        y += 30;
        UniqueItemStackSet products = new UniqueItemStackSet();
        genome.getPrimary().getGenerator().setLogBlock(genome, (World)FakeWorld.instance, 0, 0, 0, ForgeDirection.UP);
        ItemStack stackWood = FakeWorld.instance.getWooLog();
        if (stackWood != null) {
            products.add(stackWood);
        }
        if (!products.isEmpty()) {
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.wood.logs")).setColor(this.getColor());
            y += 10;
            int w = products.size() * 18 - 2;
            int i = 0;
            for (ItemStack stack : products) {
                ControlItemDisplay d = new ControlItemDisplay(this, (this.w() - (float)w) / 2.0f + (float)(18 * i), y);
                d.setTooltip();
                d.setItemStack(stack);
            }
            y += 26;
        }
        UniqueItemStackSet allProducts = new UniqueItemStackSet();
        allProducts.addAll(products);
        UniqueItemStackSet refinedProducts = new UniqueItemStackSet();
        refinedProducts.addAll(this.getAllProductsAndFluids(allProducts));
        if (!refinedProducts.isEmpty()) {
            y = this.getRefined(I18N.localise("genetics.gui.analyst.wood.products"), y, refinedProducts);
            y += 8;
        }
        if (products.isEmpty()) {
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.wood.noFruits")).setColor(this.getColor());
            y += 28;
        }
        this.setSize(new IPoint(this.w(), y + 8));
    }

    @Override
    public String getTitle() {
        return I18N.localise("genetics.gui.analyst.wood");
    }
}

