/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui;

import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.ITooltip;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.WidgetAttribute;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.geometry.IArea;
import binnie.core.craftgui.geometry.IBorder;
import binnie.core.genetics.Tolerance;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.EnumTolerance;
import java.util.EnumSet;
import net.minecraft.util.EnumChatFormatting;

public abstract class ControlToleranceBar<T extends Enum<T>>
extends Control
implements ITooltip {
    EnumSet<T> tolerated;
    EnumSet<T> fullSet;
    private final Class<T> enumClass;

    public ControlToleranceBar(IWidget parent, float x, float y, float width, float height, Class<T> clss) {
        super(parent, x, y, width, height);
        this.addAttribute(WidgetAttribute.MOUSE_OVER);
        this.enumClass = clss;
        this.tolerated = EnumSet.noneOf(this.enumClass);
        this.fullSet = EnumSet.allOf(this.enumClass);
        if (this.enumClass == EnumTemperature.class) {
            this.fullSet.remove(EnumTemperature.NONE);
        }
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        int types = this.fullSet.size();
        int type = (int)((float)((int)this.getRelativeMousePosition().x()) / (this.getSize().x() / (float)types));
        for (Enum tol : this.fullSet) {
            if (tol.ordinal() - (this.enumClass == EnumTemperature.class ? 1 : 0) != type) continue;
            tooltip.add((this.tolerated.contains(tol) ? "" : EnumChatFormatting.DARK_GRAY) + this.getName(tol));
        }
    }

    protected abstract String getName(T var1);

    protected abstract int getColor(T var1);

    @Override
    public void onRenderBackground() {
        CraftGUI.render.gradientRect(this.getArea(), -1431655766, -1431655766);
        float w = this.getArea().w() / (float)this.fullSet.size();
        int t = 0;
        for (Enum value : this.fullSet) {
            int col = (this.tolerated.contains(value) ? -16777216 : 0x33000000) + this.getColor(value);
            IBorder inset = new IBorder(this.tolerated.contains(value) ? 1.0f : 3.0f);
            CraftGUI.render.gradientRect(new IArea(w * (float)t, 0.0f, w, this.h()).inset(inset), col, col);
            ++t;
        }
    }

    public void setValues(T value, EnumTolerance enumTol) {
        this.tolerated.clear();
        Tolerance tol = Tolerance.get(enumTol);
        for (Enum full : this.fullSet) {
            if (full.ordinal() > ((Enum)value).ordinal() + tol.getBounds()[1] || full.ordinal() < ((Enum)value).ordinal() + tol.getBounds()[0]) continue;
            this.tolerated.add(full);
        }
    }
}

