/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.integration.gregtech;

import blockrenderer6343.api.utils.CreativeItemSource;
import blockrenderer6343.client.renderer.WorldSceneRenderer;
import blockrenderer6343.client.utils.BRUtil;
import blockrenderer6343.client.utils.EnumColor;
import blockrenderer6343.integration.nei.GuiMultiblockHandler;
import blockrenderer6343.integration.nei.StructureHacks;
import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructableProvider;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import cpw.mods.fml.relauncher.ReflectionHelper;
import gregtech.api.interfaces.INEIPreviewModifier;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.ITurnable;
import gregtech.api.threads.RunnableMachineUpdate;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.HatchElementBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class GTGuiMultiblockHandler
extends GuiMultiblockHandler {
    private static final Object2IntMap<IStructureElement<?>> cachedDots = new Object2IntOpenHashMap();
    private static final Int2ObjectMap<LongSet> hatchGroupPositions = new Int2ObjectLinkedOpenHashMap();
    private static final Int2ObjectMap<String> hintForDot = new Int2ObjectOpenHashMap();
    private static final Long2IntMap dotForPos = new Long2IntOpenHashMap();
    private static final List<String> hatchElements;
    private static final String HATCH_ELEMENT;
    private static final MethodHandle DOT_GETTER;
    private static final MethodHandle HINT_FALLBACK;
    private static final Pattern hintPattern;
    private boolean highlightHatch = false;

    @Override
    protected void initGui() {
        super.initGui();
        this.addButtonInRow("H").setTooltip(I18n.func_135052_a((String)"blockrenderer6343.nei.hatch_highlight", (Object[])new Object[0])).setClickAction(() -> {
            this.highlightHatch = !this.highlightHatch;
        });
    }

    @Override
    protected void loadNewMultiblock() {
        hintForDot.clear();
        dotForPos.clear();
        hatchGroupPositions.clear();
        super.loadNewMultiblock();
        this.findHints();
    }

    @Override
    public List<String> getHoveredTooltip(@NotNull ItemStack stack) {
        List<String> stackTooltip = super.getHoveredTooltip(stack);
        MovingObjectPosition mop = renderer.getLastTraceResult();
        int dot = dotForPos.get(CoordinatePacker.pack((int)mop.field_72311_b, (int)mop.field_72312_c, (int)mop.field_72309_d));
        if (dot == dotForPos.defaultReturnValue()) {
            return stackTooltip;
        }
        String hint = (String)hintForDot.get(dot);
        if (hint != null) {
            stackTooltip.add("");
            EnumChatFormatting dotColor = EnumColor.VALUES[dot % EnumColor.VALUES.length].formatting;
            stackTooltip.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"blockrenderer6343.nei.hint_dot", (Object[])new Object[]{dotColor + "" + dot}));
            String hintStr = EnumChatFormatting.GOLD + I18n.func_135052_a((String)"blockrenderer6343.nei.valid_hatches", (Object[])new Object[]{hint});
            stackTooltip.addAll(GTGuiMultiblockHandler.mc.field_71466_p.func_78271_c(hintStr, 200));
        }
        return stackTooltip;
    }

    @Override
    protected void onPostBlocksRendered(WorldSceneRenderer renderer) {
        if (!this.highlightHatch || hatchGroupPositions.isEmpty()) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8448);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        for (Int2ObjectMap.Entry entry : hatchGroupPositions.int2ObjectEntrySet()) {
            LongSet positions = (LongSet)entry.getValue();
            if (positions.isEmpty()) continue;
            int color = EnumColor.VALUES[entry.getIntKey() % EnumColor.VALUES.length].color;
            LongIterator longIterator = positions.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                if (!renderer.renderedBlocks.contains(pos)) continue;
                BRUtil.renderOverlay(positions, pos, color, 150);
            }
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    @Override
    protected void placeMultiblock() {
        INEIPreviewModifier modifier;
        if (RunnableMachineUpdate.isCurrentThreadEnabled()) {
            RunnableMachineUpdate.setCurrentThreadEnabled((boolean)false);
        }
        IConstructable constructable = null;
        ItemStack copy = this.stackForm.func_77946_l();
        copy.func_77973_b().func_77648_a(copy, (EntityPlayer)BRUtil.FAKE_PLAYER, (World)GTGuiMultiblockHandler.renderer.world, GTGuiMultiblockHandler.MB_PLACE_POS.x, GTGuiMultiblockHandler.MB_PLACE_POS.y, GTGuiMultiblockHandler.MB_PLACE_POS.z, 0, (float)GTGuiMultiblockHandler.MB_PLACE_POS.x, (float)GTGuiMultiblockHandler.MB_PLACE_POS.y, (float)GTGuiMultiblockHandler.MB_PLACE_POS.z);
        TileEntity tTileEntity = GTGuiMultiblockHandler.renderer.world.func_147438_o(GTGuiMultiblockHandler.MB_PLACE_POS.x, GTGuiMultiblockHandler.MB_PLACE_POS.y, GTGuiMultiblockHandler.MB_PLACE_POS.z);
        ((ITurnable)tTileEntity).setFrontFacing(ForgeDirection.SOUTH);
        IMetaTileEntity mte = ((IGregTechTileEntity)tTileEntity).getMetaTileEntity();
        if (mte instanceof INEIPreviewModifier) {
            modifier = (INEIPreviewModifier)mte;
            modifier.onPreviewConstruct(this.getBuildTriggerStack());
        }
        if (mte instanceof ISurvivalConstructable) {
            ISurvivalConstructable survivalConstructable = (ISurvivalConstructable)mte;
            int iterations = 0;
            do {
                survivalConstructable.survivalConstruct(this.getBuildTriggerStack(), Integer.MAX_VALUE, ISurvivalBuildEnvironment.create((IItemSource)CreativeItemSource.instance, (EntityPlayer)BRUtil.FAKE_PLAYER));
            } while (GTGuiMultiblockHandler.renderer.world.hasChanged() && ++iterations < 2000);
        } else if (tTileEntity instanceof IConstructableProvider) {
            IConstructableProvider iConstructableProvider = (IConstructableProvider)tTileEntity;
            constructable = iConstructableProvider.getConstructable();
        } else if (tTileEntity instanceof IConstructable) {
            IConstructable iConstructable;
            constructable = iConstructable = (IConstructable)tTileEntity;
        }
        if (constructable != null) {
            constructable.construct(this.getBuildTriggerStack(), false);
        }
        if (mte instanceof INEIPreviewModifier) {
            modifier = (INEIPreviewModifier)mte;
            modifier.onPreviewStructureComplete(this.getBuildTriggerStack());
        }
        if (!RunnableMachineUpdate.isCurrentThreadEnabled()) {
            RunnableMachineUpdate.setCurrentThreadEnabled((boolean)true);
        }
    }

    @Override
    protected void onElementAdded(@NotNull IStructureElement<Object> element, long pos) {
        if (StructureHacks.anyElementMatches(hatchElements, renderingController, element)) {
            int dot = this.getDotForElement(element);
            if (dot == dotForPos.defaultReturnValue()) {
                return;
            }
            ((LongSet)hatchGroupPositions.computeIfAbsent(dot, k -> new LongOpenHashSet())).add(pos);
            dotForPos.put(pos, dot);
        }
    }

    private void findHints() {
        for (String string : renderingController.getStructureDescription(this.getBuildTriggerStack())) {
            Matcher matcher = hintPattern.matcher(string);
            if (!matcher.find()) continue;
            String match = matcher.group();
            int dot = Integer.parseInt(match.split(" ")[1]);
            String hint = string.replace(match, "");
            hintForDot.put(dot, (Object)hint);
        }
        if (hintForDot.size() != hatchGroupPositions.size()) {
            IntArrayList missing = new IntArrayList((IntCollection)hatchGroupPositions.keySet());
            missing.removeAll((IntCollection)hintForDot.keySet());
            IntListIterator intListIterator = missing.iterator();
            block1: while (intListIterator.hasNext()) {
                int dot = (Integer)intListIterator.next();
                LongIterator longIterator = ((LongSet)hatchGroupPositions.get(dot)).iterator();
                while (longIterator.hasNext()) {
                    long pos = (Long)longIterator.next();
                    String hint = this.getFallbackHint((IStructureElement<Object>)((IStructureElement)structureElementMap.get(pos)));
                    if (hint.isEmpty()) continue;
                    hintForDot.put(dot, (Object)hint);
                    continue block1;
                }
            }
        }
    }

    private int getDotForElement(IStructureElement<Object> element) {
        return cachedDots.computeIfAbsent(element, a -> {
            IStructureElement<IConstructable> match = StructureHacks.getFirstMatchingElement(HATCH_ELEMENT, renderingController, element);
            if (match == null) {
                return dotForPos.defaultReturnValue();
            }
            try {
                return (Integer)DOT_GETTER.invokeWithArguments(match);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
    }

    private String getFallbackHint(@Nullable IStructureElement<Object> element) {
        IStructureElement<Object> hatchEle = StructureHacks.getFirstMatchingElement(HATCH_ELEMENT, renderingController, element);
        if (hatchEle == null) {
            return "";
        }
        try {
            int index;
            String hint = (String)HINT_FALLBACK.invokeWithArguments(hatchEle);
            StringBuilder builder = new StringBuilder(hint);
            int typeIndex = builder.indexOf("of type");
            if (typeIndex == -1) {
                return hint;
            }
            builder.replace(0, 7, "");
            while ((index = builder.indexOf(" or")) != -1) {
                int last = builder.lastIndexOf(" or");
                String replacement = last == index ? " and" : ",";
                builder.replace(index, index + 3, replacement);
            }
            return builder.toString();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static {
        hintPattern = Pattern.compile("Hint \\d+ dot:");
        dotForPos.defaultReturnValue(9999);
        HatchElementBuilder builder = GTStructureUtility.buildHatchAdder().adder((a, b, c) -> true).casingIndex(1).dot(1);
        String hatchNoPlacement = builder.build().getClass().getName();
        IStructureElement hatchEle = builder.hatchItemFilter((a, b) -> c -> true).build();
        HATCH_ELEMENT = hatchEle.getClass().getName();
        String chained = builder.buildAndChain(new IStructureElement[0]).getClass().getName();
        hatchElements = ImmutableList.of((Object)HATCH_ELEMENT, (Object)hatchNoPlacement, (Object)chained);
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle hatchBuilder = lookup.unreflectGetter(ReflectionHelper.findField(hatchEle.getClass(), (String[])new String[]{"this$0"}));
            MethodHandle dot = lookup.unreflectGetter(ReflectionHelper.findField(HatchElementBuilder.class, (String[])new String[]{"mDot"}));
            DOT_GETTER = MethodHandles.filterReturnValue(hatchBuilder, dot);
            HINT_FALLBACK = lookup.unreflect(ReflectionHelper.findMethod(hatchEle.getClass(), null, (String[])new String[]{"getHint"}, (Class[])new Class[0]));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

