/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.BCLog;
import buildcraft.core.IMCHandler;
import buildcraft.core.crops.CropHandlerPlantable;
import buildcraft.core.recipes.AssemblyRecipeManager;
import buildcraft.core.recipes.RefineryRecipeManager;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;

public final class InterModComms {
    private static final Set<IMCHandler> handlers = new HashSet<IMCHandler>();

    private InterModComms() {
    }

    public static void registerHandler(IMCHandler handler) {
        handlers.add(handler);
    }

    public static void processIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage m : event.getMessages()) {
            if (m.key.equals("add-assembly-recipe")) {
                InterModComms.processAssemblyRecipeAddIMC(event, m);
                continue;
            }
            if (m.key.equals("add-refinery-recipe")) {
                InterModComms.processRefineryRecipeAddIMC(event, m);
                continue;
            }
            if (m.key.equals("remove-assembly-recipe")) {
                InterModComms.processAssemblyRecipeRemoveIMC(event, m);
                continue;
            }
            if (m.key.equals("remove-refinery-recipe")) {
                InterModComms.processRefineryRecipeRemoveIMC(event, m);
                continue;
            }
            if (m.key.equals("remove-plantable-block")) {
                InterModComms.processPlantableBlockRemoveIMC(event, m);
                continue;
            }
            for (IMCHandler h : handlers) {
                h.processIMCEvent(event, m);
            }
        }
    }

    public static void processPlantableBlockRemoveIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage msg) {
        if (msg.isStringMessage()) {
            Object blockObj = Block.field_149771_c.func_82594_a(msg.getStringValue());
            if (blockObj instanceof Block) {
                CropHandlerPlantable.forbidBlock((Block)blockObj);
            }
            BCLog.logger.info(String.format("Received a plantable block '%s' removal request from mod %s", msg.getStringValue(), msg.getSender()));
        }
    }

    public static void processAssemblyRecipeRemoveIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage msg) {
        if (msg.isStringMessage()) {
            AssemblyRecipeManager.INSTANCE.removeRecipe(msg.getStringValue());
            BCLog.logger.info(String.format("Received an assembly recipe '%s' removal request from mod %s", msg.getStringValue(), msg.getSender()));
        }
    }

    public static void processRefineryRecipeRemoveIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage msg) {
        if (msg.isStringMessage()) {
            RefineryRecipeManager.INSTANCE.removeRecipe(msg.getStringValue());
            BCLog.logger.info(String.format("Received a refinery recipe '%s' removal request from mod %s", msg.getStringValue(), msg.getSender()));
        }
    }

    public static void processAssemblyRecipeAddIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage msg) {
        boolean failed = false;
        if (!msg.isNBTMessage()) {
            failed = true;
        } else {
            NBTTagCompound recipe = msg.getNBTValue();
            if (!(recipe.func_74764_b("id") && recipe.func_150297_b("input", 9) && recipe.func_150297_b("output", 10) && recipe.func_150297_b("energy", 3))) {
                failed = true;
            } else {
                ItemStack is;
                NBTTagList list = (NBTTagList)recipe.func_74781_a("input");
                ArrayList<ItemStack> input = new ArrayList<ItemStack>();
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    is = ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(i));
                    if (is == null) continue;
                    input.add(is);
                }
                String id = recipe.func_74779_i("id");
                is = ItemStack.func_77949_a((NBTTagCompound)recipe.func_74775_l("output"));
                if (is != null && !input.isEmpty() && id.length() > 0) {
                    AssemblyRecipeManager.INSTANCE.addRecipe(id, recipe.func_74762_e("energy"), is, input.toArray(new ItemStack[input.size()]));
                } else {
                    failed = true;
                }
            }
        }
        if (failed) {
            BCLog.logger.warn("Received invalid assembly recipe IMC message from mod %s!", new Object[]{msg.getSender()});
        }
    }

    public static void processRefineryRecipeAddIMC(FMLInterModComms.IMCEvent event, FMLInterModComms.IMCMessage msg) {
        boolean failed = false;
        if (!msg.isNBTMessage()) {
            failed = true;
        } else {
            NBTTagCompound recipe = msg.getNBTValue();
            if (!((recipe.func_74764_b("id") || recipe.func_150297_b("input", 10)) && recipe.func_150297_b("output", 10) && recipe.func_150297_b("energy", 3) && recipe.func_150297_b("delay", 3))) {
                failed = true;
            } else {
                FluidStack output = FluidStack.loadFluidStackFromNBT((NBTTagCompound)recipe.func_74775_l("output"));
                FluidStack input = FluidStack.loadFluidStackFromNBT((NBTTagCompound)recipe.func_74775_l("input"));
                FluidStack input2 = null;
                String id = recipe.func_74779_i("id");
                if (recipe.func_150297_b("input_2", 10)) {
                    input2 = FluidStack.loadFluidStackFromNBT((NBTTagCompound)recipe.func_74775_l("input_2"));
                }
                if (input != null && output != null && id.length() > 0) {
                    RefineryRecipeManager.INSTANCE.addRecipe(id, input, input2, output, recipe.func_74762_e("energy"), recipe.func_74762_e("delay"));
                } else {
                    failed = true;
                }
            }
        }
        if (failed) {
            BCLog.logger.warn("Received invalid refinery recipe IMC message from mod %s!", new Object[]{msg.getSender()});
        }
    }
}

