/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.builders.patterns;

import buildcraft.api.filler.IFillerPattern;
import buildcraft.api.filler.IFillerRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class FillerRegistry
implements IFillerRegistry {
    private TreeMap<String, IFillerPattern> patterns = new TreeMap();

    @Override
    public void addPattern(IFillerPattern pattern) {
        this.patterns.put(pattern.getUniqueTag(), pattern);
    }

    @Override
    public IFillerPattern getPattern(String patternName) {
        return this.patterns.get(patternName);
    }

    @Override
    public IFillerPattern getNextPattern(IFillerPattern currentPattern) {
        Map.Entry<String, IFillerPattern> pattern = this.patterns.higherEntry(currentPattern.getUniqueTag());
        if (pattern == null) {
            pattern = this.patterns.firstEntry();
        }
        return pattern.getValue();
    }

    @Override
    public IFillerPattern getPreviousPattern(IFillerPattern currentPattern) {
        Map.Entry<String, IFillerPattern> pattern = this.patterns.lowerEntry(currentPattern.getUniqueTag());
        if (pattern == null) {
            pattern = this.patterns.lastEntry();
        }
        return pattern.getValue();
    }

    @Override
    public Collection<IFillerPattern> getPatterns() {
        return Collections.unmodifiableCollection(this.patterns.values());
    }
}

