/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.utils;

import buildcraft.core.lib.utils.MathUtils;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public final class NetworkUtils {
    private NetworkUtils() {
    }

    public static void writeUTF(ByteBuf data, String str) {
        try {
            if (str == null) {
                data.writeInt(0);
                return;
            }
            byte[] b = str.getBytes("UTF-8");
            data.writeInt(b.length);
            data.writeBytes(b);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            data.writeInt(0);
        }
    }

    public static String readUTF(ByteBuf data) {
        try {
            int len = data.readInt();
            if (len == 0) {
                return "";
            }
            byte[] b = new byte[len];
            data.readBytes(b);
            return new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeNBT(ByteBuf data, NBTTagCompound nbt) {
        try {
            byte[] compressed = CompressedStreamTools.func_74798_a((NBTTagCompound)nbt);
            data.writeInt(compressed.length);
            data.writeBytes(compressed);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static NBTTagCompound readNBT(ByteBuf data) {
        try {
            int length = data.readInt();
            byte[] compressed = new byte[length];
            data.readBytes(compressed);
            return CompressedStreamTools.func_152457_a((byte[])compressed, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeStack(ByteBuf data, ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null || stack.field_77994_a < 0) {
            data.writeByte(0);
        } else {
            data.writeByte(MathUtils.clamp(stack.field_77994_a + 1, 0, 64) & 0x7F | (stack.func_77942_o() ? 128 : 0));
            data.writeShort(Item.func_150891_b((Item)stack.func_77973_b()));
            data.writeShort(stack.func_77960_j());
            if (stack.func_77942_o()) {
                NetworkUtils.writeNBT(data, stack.func_77978_p());
            }
        }
    }

    public static ItemStack readStack(ByteBuf data) {
        short flags = data.readUnsignedByte();
        if (flags == 0) {
            return null;
        }
        boolean hasCompound = (flags & 0x80) != 0;
        int stackSize = (flags & 0x7F) - 1;
        int itemId = data.readUnsignedShort();
        short itemDamage = data.readShort();
        ItemStack stack = new ItemStack(Item.func_150899_d((int)itemId), stackSize, (int)itemDamage);
        if (hasCompound) {
            stack.func_77982_d(NetworkUtils.readNBT(data));
        }
        return stack;
    }

    public static void writeByteArray(ByteBuf stream, byte[] data) {
        stream.writeInt(data.length);
        stream.writeBytes(data);
    }

    public static byte[] readByteArray(ByteBuf stream) {
        byte[] data = new byte[stream.readInt()];
        stream.readBytes(data, 0, data.length);
        return data;
    }
}

