/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.properties;

import java.util.BitSet;
import net.minecraft.world.IBlockAccess;

public class ChunkProperty {
    private BitSet property;
    private int worldHeight;
    private int xPosition;
    private int zPosition;
    private IBlockAccess blockAccess;

    public ChunkProperty(IBlockAccess iBlockAccess, int iWorldHeight, int iXPosition, int iZPosition) {
        this.worldHeight = iWorldHeight;
        this.property = new BitSet(256 * this.worldHeight / 8);
        this.xPosition = iXPosition;
        this.zPosition = iZPosition;
        this.blockAccess = iBlockAccess;
    }

    public boolean get(int xChunk, int y, int zChunk) {
        return this.property.get(xChunk * this.worldHeight * 16 + y * 16 + zChunk);
    }

    public void set(int xChunk, int y, int zChunk, boolean value) {
        this.property.set(xChunk * this.worldHeight * 16 + y * 16 + zChunk, value);
    }
}

