/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.IInvSlot;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.IRequestProvider;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.core.lib.inventory.filters.ArrayStackOrListFilter;
import buildcraft.robotics.StackRequest;
import buildcraft.robotics.ai.AIRobotGotoStation;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class AIRobotDeliverRequested
extends AIRobot {
    private StackRequest requested;
    private boolean delivered = false;

    public AIRobotDeliverRequested(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotDeliverRequested(EntityRobotBase robot, StackRequest request) {
        this(robot);
        this.requested = request;
    }

    @Override
    public void start() {
        if (this.requested != null) {
            this.startDelegateAI(new AIRobotGotoStation(this.robot, this.requested.getStation(this.robot.field_70170_p)));
        } else {
            this.setSuccess(false);
            this.terminate();
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotGotoStation) {
            if (!ai.success()) {
                this.setSuccess(false);
                this.terminate();
                return;
            }
            IRequestProvider requester = this.requested.getRequester(this.robot.field_70170_p);
            if (requester == null) {
                this.setSuccess(false);
                this.terminate();
                return;
            }
            int count = 0;
            for (IInvSlot slot : InvUtils.getItems(this.robot, new ArrayStackOrListFilter(this.requested.getStack()))) {
                int difference = slot.getStackInSlot().field_77994_a;
                ItemStack newStack = requester.offerItem(this.requested.getSlot(), slot.getStackInSlot().func_77946_l());
                if (newStack == null) {
                    slot.setStackInSlot(newStack);
                } else if (newStack.field_77994_a != slot.getStackInSlot().field_77994_a) {
                    slot.setStackInSlot(newStack);
                    difference = newStack.field_77994_a - difference;
                }
                count += difference;
            }
            this.setSuccess(count > 0);
            this.terminate();
        }
    }

    @Override
    public boolean success() {
        return this.delivered;
    }

    @Override
    public boolean canLoadFromNBT() {
        return true;
    }

    @Override
    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.requested != null) {
            NBTTagCompound requestNBT = new NBTTagCompound();
            this.requested.writeToNBT(requestNBT);
            nbt.func_74782_a("currentRequest", (NBTBase)requestNBT);
        }
    }

    @Override
    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.func_74764_b("currentRequest")) {
            this.requested = StackRequest.loadFromNBT(nbt.func_74775_l("currentRequest"));
        }
    }
}

