/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.EnumColor;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.ISerializable;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.StatementSlot;
import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.utils.ColorUtils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.PipeItemsWood;
import buildcraft.transport.pipes.PipeLogicIron;
import buildcraft.transport.pipes.events.PipeEventItem;
import buildcraft.transport.statements.ActionPipeColor;
import buildcraft.transport.statements.ActionPipeDirection;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsDaizuli
extends Pipe<PipeTransportItems>
implements ISerializable {
    private int standardIconIndex = PipeIconProvider.TYPE.PipeItemsDaizuli_Black.ordinal();
    private int solidIconIndex = PipeIconProvider.TYPE.PipeAllDaizuli_Solid.ordinal();
    private int color = EnumColor.BLACK.ordinal();
    private PipeLogicIron logic = new PipeLogicIron(this){

        @Override
        protected boolean isValidConnectingTile(TileEntity tile) {
            if (tile instanceof IPipeTile) {
                Pipe otherPipe = (Pipe)((IPipeTile)tile).getPipe();
                if (otherPipe instanceof PipeItemsWood) {
                    return false;
                }
                return otherPipe.transport instanceof PipeTransportItems;
            }
            return tile instanceof IInventory;
        }
    };

    public PipeItemsDaizuli(Item item) {
        super(new PipeTransportItems(), item);
        ((PipeTransportItems)this.transport).allowBouncing = true;
    }

    public EnumColor getColor() {
        return EnumColor.fromId(this.color);
    }

    public void setColor(EnumColor c) {
        if (this.color != c.ordinal()) {
            this.color = c.ordinal();
            this.container.scheduleRenderUpdate();
        }
    }

    @Override
    public boolean blockActivated(EntityPlayer player, ForgeDirection side) {
        int newColor;
        if (player.func_70093_af()) {
            Item equipped;
            Item item = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
            if (equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(player, this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e)) {
                this.setColor(this.getColor().getNext());
                ((IToolWrench)equipped).wrenchUsed(player, this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
                return true;
            }
        }
        if ((newColor = ColorUtils.getColorIDFromDye(player.func_71045_bC())) >= 0 && newColor < 16) {
            this.setColor(EnumColor.fromId(15 - newColor));
            return true;
        }
        return this.logic.blockActivated(player, side);
    }

    @Override
    public void onBlockPlaced() {
        this.logic.onBlockPlaced();
        super.onBlockPlaced();
    }

    @Override
    public void initialize() {
        this.logic.initialize();
        super.initialize();
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return this.standardIconIndex + this.color;
        }
        if (this.container != null && this.container.func_145832_p() == direction.ordinal()) {
            return this.standardIconIndex + this.color;
        }
        return this.solidIconIndex;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    public void eventHandler(PipeEventItem.FindDest event) {
        ForgeDirection output = ForgeDirection.getOrientation((int)this.container.func_145832_p());
        if (event.item.color == this.getColor() && event.destinations.contains(output)) {
            event.destinations.clear();
            event.destinations.add(output);
            return;
        }
        event.destinations.remove(output);
    }

    public void eventHandler(PipeEventItem.AdjustSpeed event) {
        event.slowdownAmount /= 4.0f;
    }

    @Override
    protected void actionsActivated(Collection<StatementSlot> actions) {
        super.actionsActivated(actions);
        for (StatementSlot action : actions) {
            if (!(action.statement instanceof ActionPipeColor)) continue;
            this.setColor(((ActionPipeColor)action.statement).color);
            break;
        }
        for (StatementSlot action : actions) {
            if (!(action.statement instanceof ActionPipeDirection)) continue;
            this.logic.setFacing(((ActionPipeDirection)action.statement).direction);
            break;
        }
    }

    @Override
    public LinkedList<IActionInternal> getActions() {
        LinkedList<IActionInternal> action = super.getActions();
        action.addAll(Arrays.asList(BuildCraftTransport.actionPipeColor));
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.container.isPipeConnected(direction)) continue;
            action.add(BuildCraftTransport.actionPipeDirection[direction.ordinal()]);
        }
        return action;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74774_a("color", (byte)this.color);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.color = data.func_74771_c("color");
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeByte(this.color);
    }

    @Override
    public void readData(ByteBuf data) {
        this.color = data.readByte();
    }
}

