/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.StatementSlot;
import buildcraft.api.transport.IPipeTile;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.PipeItemsWood;
import buildcraft.transport.pipes.PipeLogicIron;
import buildcraft.transport.statements.ActionPipeDirection;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsIron
extends Pipe<PipeTransportItems> {
    private int standardIconIndex = PipeIconProvider.TYPE.PipeItemsIron_Standard.ordinal();
    private int solidIconIndex = PipeIconProvider.TYPE.PipeAllIron_Solid.ordinal();
    private PipeLogicIron logic = new PipeLogicIron(this){

        @Override
        protected boolean isValidConnectingTile(TileEntity tile) {
            if (tile instanceof IPipeTile) {
                Pipe otherPipe = (Pipe)((IPipeTile)tile).getPipe();
                if (otherPipe instanceof PipeItemsWood) {
                    return false;
                }
                return otherPipe.transport instanceof PipeTransportItems;
            }
            return tile instanceof IInventory;
        }
    };

    public PipeItemsIron(Item item) {
        super(new PipeTransportItems(), item);
        ((PipeTransportItems)this.transport).allowBouncing = true;
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer, ForgeDirection side) {
        return this.logic.blockActivated(entityplayer, side);
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        this.logic.switchOnRedstone();
        super.onNeighborBlockChange(blockId);
    }

    @Override
    public void onBlockPlaced() {
        this.logic.onBlockPlaced();
        super.onBlockPlaced();
    }

    @Override
    public void initialize() {
        this.logic.initialize();
        super.initialize();
    }

    @Override
    public boolean outputOpen(ForgeDirection to) {
        return super.outputOpen(to) && this.logic.outputOpen(to);
    }

    @Override
    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return this.standardIconIndex;
        }
        int metadata = this.container.func_145832_p();
        if (metadata != direction.ordinal()) {
            return this.solidIconIndex;
        }
        return this.standardIconIndex;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BuildCraftTransport.instance.pipeIconProvider;
    }

    @Override
    protected void actionsActivated(Collection<StatementSlot> actions) {
        super.actionsActivated(actions);
        for (StatementSlot action : actions) {
            if (!(action.statement instanceof ActionPipeDirection)) continue;
            this.logic.setFacing(((ActionPipeDirection)action.statement).direction);
            break;
        }
    }

    @Override
    public LinkedList<IActionInternal> getActions() {
        LinkedList<IActionInternal> action = super.getActions();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.container.isPipeConnected(direction)) continue;
            action.add(BuildCraftTransport.actionPipeDirection[direction.ordinal()]);
        }
        return action;
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }
}

