/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.recipes;

import buildcraft.api.gates.GateExpansions;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.recipes.IntegrationRecipeBC;
import buildcraft.silicon.ItemRedstoneChipset;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.ItemGate;
import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;

public class GateExpansionRecipe
extends IntegrationRecipeBC {
    private static final BiMap<IGateExpansion, ItemStack> recipes = (BiMap)GateExpansions.getRecipesForPostInit();

    public GateExpansionRecipe() {
        super(25000);
    }

    @Override
    public boolean isValidInput(ItemStack input) {
        return input.func_77973_b() instanceof ItemGate;
    }

    @Override
    public boolean isValidExpansion(ItemStack input, ItemStack expansion) {
        if (StackHelper.isMatchingItem(ItemRedstoneChipset.Chipset.RED.getStack(), expansion, true, true)) {
            return true;
        }
        for (ItemStack s : recipes.values()) {
            if (!StackHelper.isMatchingItem(s, expansion, true, true)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ItemStack> generateExampleInput() {
        return Collections.unmodifiableList(ItemGate.getAllGates());
    }

    @Override
    public List<ItemStack> generateExampleOutput() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ArrayList<IGateExpansion> exps = new ArrayList<IGateExpansion>();
        int combinations = recipes.size();
        for (IGateExpansion exp : recipes.keySet()) {
            exps.add(exp);
        }
        for (int i = 0; i < 1 << combinations; ++i) {
            for (GateDefinition.GateLogic l : GateDefinition.GateLogic.VALUES) {
                for (GateDefinition.GateMaterial m : GateDefinition.GateMaterial.VALUES) {
                    ItemStack s = ItemGate.makeGateItem(m, l);
                    for (int j = 0; j < combinations; ++j) {
                        if ((i >> j & 1) == 0) continue;
                        ItemGate.addGateExpansion(s, (IGateExpansion)exps.get(j));
                    }
                    list.add(s);
                }
            }
        }
        return list;
    }

    @Override
    public List<List<ItemStack>> generateExampleExpansions() {
        ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
        ArrayList list2 = new ArrayList();
        list2.addAll(recipes.values());
        list.add(list2);
        return list;
    }

    @Override
    public ItemStack craft(ItemStack input, List<ItemStack> expansions, boolean preview) {
        ItemStack output = input.func_77946_l();
        output.field_77994_a = 1;
        int expansionsAdded = 0;
        block0: for (ItemStack chipset : expansions) {
            if (StackHelper.isMatchingItem(ItemRedstoneChipset.Chipset.RED.getStack(), chipset, true, true)) {
                ItemGate.setLogic(output, ItemGate.getLogic(output) == GateDefinition.GateLogic.AND ? GateDefinition.GateLogic.OR : GateDefinition.GateLogic.AND);
                ++expansionsAdded;
                continue;
            }
            for (ItemStack expansion : recipes.values()) {
                if (!StackHelper.isMatchingItem(chipset, expansion, true, true) || ItemGate.hasGateExpansion(output, (IGateExpansion)recipes.inverse().get((Object)expansion))) continue;
                if (!preview) {
                    --chipset.field_77994_a;
                }
                ItemGate.addGateExpansion(output, (IGateExpansion)recipes.inverse().get((Object)expansion));
                ++expansionsAdded;
                continue block0;
            }
        }
        if (expansionsAdded > 0) {
            return output;
        }
        return null;
    }
}

