/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.factorization;

import buildcraft.compat.CompatModuleFactorization;
import cofh.api.energy.IEnergyReceiver;
import factorization.api.Charge;
import factorization.api.IChargeConductor;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class ChargeEnergyReceiver
implements IEnergyReceiver {
    private final Charge charge;
    private final IChargeConductor conductor;
    private int microFluxes;

    public ChargeEnergyReceiver(TileEntity chargeConductor) {
        this.conductor = (IChargeConductor)chargeConductor;
        this.charge = this.conductor.getCharge();
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        int maxCharge = Math.min(5, 100 - this.charge.getValue());
        if (maxCharge < 0) {
            return 0;
        }
        int rfToUse = (int)Math.floor((float)maxCharge / CompatModuleFactorization.CHARGE_PER_RF);
        if (!simulate) {
            int chargeVal = (int)Math.floor((float)maxCharge + (float)this.microFluxes * CompatModuleFactorization.CHARGE_PER_RF);
            int rfInserted = (int)Math.floor((float)chargeVal / CompatModuleFactorization.CHARGE_PER_RF);
            this.microFluxes += rfToUse - rfInserted;
            this.charge.addValue(chargeVal);
        }
        return rfToUse;
    }

    public int getEnergyStored(ForgeDirection from) {
        return (int)Math.floor((float)this.charge.getValue() / CompatModuleFactorization.CHARGE_PER_RF);
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getEnergyStored(from) + 1;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }
}

