/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.forestry.pipes;

import buildcraft.BuildCraftCompat;
import buildcraft.api.core.IIconProvider;
import buildcraft.compat.CompatModuleForestry;
import buildcraft.compat.forestry.pipes.EnumFilterType;
import buildcraft.compat.forestry.pipes.PipeIconProvider;
import buildcraft.compat.forestry.pipes.PipeLogicPropolis;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.events.PipeEventItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.IAllele;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsPropolis
extends Pipe<PipeTransportItems> {
    public final PipeLogicPropolis pipeLogic = new PipeLogicPropolis(this);
    IIconProvider provider;

    public PipeItemsPropolis(Item item) {
        super((PipeTransport)new PipeTransportItems(), item);
        ((PipeTransportItems)this.transport).allowBouncing = true;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.pipeLogic.readFromNBT(nbt);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.pipeLogic.writeToNBT(nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        if (this.provider == null) {
            this.provider = new PipeIconProvider();
        }
        return this.provider;
    }

    public int getIconIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return 0;
        }
        return direction.ordinal() + 1;
    }

    public int getIconIndexForItem() {
        return 7;
    }

    public boolean blockActivated(EntityPlayer player, ForgeDirection side) {
        if (this.getWorld().field_72995_K) {
            return true;
        }
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() != null && Block.func_149634_a((Item)player.func_71045_bC().func_77973_b()) instanceof BlockGenericPipe) {
            return false;
        }
        player.openGui((Object)BuildCraftCompat.instance, 0, player.field_70170_p, this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
        return true;
    }

    public void eventHandler(PipeEventItem.FindDest event) {
        LinkedList<ForgeDirection> filteredOrientations = new LinkedList<ForgeDirection>();
        LinkedList<ForgeDirection> typedOrientations = new LinkedList<ForgeDirection>();
        LinkedList<ForgeDirection> defaultOrientations = new LinkedList<ForgeDirection>();
        EnumFilterType type = EnumFilterType.getType(event.item.getItemStack());
        IBee bee = null;
        if (type != EnumFilterType.ITEM) {
            bee = CompatModuleForestry.beeRoot.getMember(event.item.getItemStack());
        }
        for (ForgeDirection dir : event.destinations) {
            if (this.pipeLogic.isClosed(dir)) continue;
            if (this.pipeLogic.isIndiscriminate(dir)) {
                defaultOrientations.add(dir);
                continue;
            }
            if (!this.pipeLogic.matchType(dir, type, bee)) continue;
            if (type == EnumFilterType.ITEM) {
                filteredOrientations.add(dir);
                continue;
            }
            ArrayList<IAllele[]> filters = this.pipeLogic.getGenomeFilters(dir);
            if (filters.size() <= 0) {
                typedOrientations.add(dir);
                continue;
            }
            for (IAllele[] pattern : filters) {
                if (!PipeItemsPropolis.matchAllele(pattern[0], bee.getIdent()) || !PipeItemsPropolis.matchAllele(pattern[1], bee.getGenome().getSecondary().getUID())) continue;
                filteredOrientations.add(dir);
            }
        }
        event.destinations.clear();
        if (filteredOrientations.size() > 0) {
            event.destinations.addAll(filteredOrientations);
        } else if (typedOrientations.size() > 0) {
            event.destinations.addAll(typedOrientations);
        } else {
            event.destinations.addAll(defaultOrientations);
        }
    }

    private static boolean matchAllele(IAllele filter, String ident) {
        return filter == null || filter.getUID().equals(ident);
    }

    public void eventHandler(PipeEventItem.Entered event) {
        try {
            event.item.setSpeed(0.19999999f);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

