/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.item.chisel;

import com.cricketcraft.chisel.api.IChiselItem;
import com.cricketcraft.chisel.api.carving.ICarvingRegistry;
import com.cricketcraft.chisel.api.carving.ICarvingVariation;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import team.chisel.Chisel;
import team.chisel.carving.Carving;
import team.chisel.config.Configurations;
import team.chisel.item.chisel.ChiselController;

public class ItemChisel
extends Item
implements IChiselItem {
    public static ICarvingRegistry carving = Carving.chisel;
    private ChiselType type;

    public ItemChisel(ChiselType type) {
        this.type = type;
        this.func_77625_d(1);
        this.func_111206_d("chisel:chisel_" + type.name().toLowerCase(Locale.ENGLISH));
        if (type == ChiselType.NETHERSTAR && Chisel.gtnhLoaded) {
            this.func_77655_b("chisel.chisel_" + type.name().toLowerCase() + ".gtnh");
        } else {
            this.func_77655_b("chisel.chisel_" + type.name().toLowerCase());
        }
    }

    public int getMaxDamage(ItemStack stack) {
        if (Configurations.allowChiselDamage) {
            return this.type.maxDamage;
        }
        return 0;
    }

    public boolean func_77645_m() {
        return Configurations.allowChiselDamage;
    }

    public boolean func_82789_a(ItemStack damagedItem, ItemStack repairMaterial) {
        switch (this.type) {
            case DIAMOND: {
                return repairMaterial.func_77973_b().equals(Items.field_151045_i);
            }
            case IRON: {
                return repairMaterial.func_77973_b().equals(Items.field_151042_j);
            }
            case OBSIDIAN: {
                return repairMaterial.func_77973_b().equals(Item.func_150898_a((Block)Blocks.field_150343_Z));
            }
            case NETHERSTAR: {
                return repairMaterial.func_77973_b().equals(Items.field_151156_bN);
            }
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean held) {
        String base = "item.chisel.chisel.desc.";
        String gui = I18n.func_135052_a((String)(base + "gui"), (Object[])new Object[0]);
        String lc1 = I18n.func_135052_a((String)(base + "lc1"), (Object[])new Object[0]);
        String lc2 = I18n.func_135052_a((String)(base + "lc2"), (Object[])new Object[0]);
        String modes = I18n.func_135052_a((String)(base + "modes"), (Object[])new Object[0]);
        list.add(gui);
        if (this.type == ChiselType.DIAMOND || this.type == ChiselType.OBSIDIAN || this.type == ChiselType.NETHERSTAR || Configurations.ironChiselCanLeftClick) {
            list.add(lc1);
            list.add(lc2);
        }
        if (this.type == ChiselType.DIAMOND || this.type == ChiselType.OBSIDIAN || this.type == ChiselType.NETHERSTAR || Configurations.ironChiselHasModes) {
            list.add("");
            list.add(modes);
        }
    }

    public boolean func_77662_d() {
        return true;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Chisel Damage", (double)this.type.attackDamage, 0));
        return multimap;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return super.func_77644_a(stack, attacker, target);
    }

    @Override
    public boolean canOpenGui(World world, EntityPlayer player, ItemStack chisel) {
        return true;
    }

    @Override
    public boolean canChisel(World world, ItemStack chisel, ICarvingVariation target) {
        return true;
    }

    @Override
    public boolean onChisel(World world, ItemStack chisel, ICarvingVariation target) {
        return Configurations.allowChiselDamage;
    }

    @Override
    public boolean canChiselBlock(World world, EntityPlayer player, int x, int y, int z, Block block, int metadata) {
        return this.type == ChiselType.DIAMOND || this.type == ChiselType.OBSIDIAN || this.type == ChiselType.NETHERSTAR || Configurations.ironChiselCanLeftClick;
    }

    @Override
    public boolean hasModes(ItemStack chisel) {
        return this.type == ChiselType.DIAMOND || this.type == ChiselType.OBSIDIAN || this.type == ChiselType.NETHERSTAR || Configurations.ironChiselHasModes;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (!world.field_72995_K && this.canOpenGui(world, player, itemStack)) {
            ChiselController.INSTANCE.openQueue.add(new ChiselController.GuiOpen(player, itemStack));
        }
        return itemStack;
    }

    public static enum ChiselType {
        IRON(Configurations.ironChiselMaxDamage, Configurations.ironChiselAttackDamage),
        DIAMOND(Configurations.diamondChiselMaxDamage, Configurations.diamondChiselAttackDamage),
        OBSIDIAN(Configurations.obsidianChiselMaxDamage, Configurations.obsidianChiselAttackDamage),
        NETHERSTAR(Configurations.netherStarChiselMaxDamage, Configurations.netherStarChiselAttackDamage);

        final int maxDamage;
        final int attackDamage;

        private ChiselType(int maxDamage, int attackDamage) {
            this.maxDamage = maxDamage;
            this.attackDamage = attackDamage;
        }
    }
}

