/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.repackage.makamys.mclib.core.sharedstate;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.versioning.ComparableVersion;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import makamys.coretweaks.repackage.makamys.mclib.core.MCLib;
import makamys.coretweaks.repackage.makamys.mclib.core.sharedstate.SharedModuleMethodRedirector;
import makamys.coretweaks.repackage.makamys.mclib.core.sharedstate.SharedReference;
import makamys.coretweaks.repackage.net.sf.cglib.proxy.Enhancer;
import org.apache.commons.lang3.mutable.MutableObject;

public class SharedLibHelper {
    private static List<String> existingLibPackages = (List)SharedReference.get("mclib", "existingLibPackages", ArrayList.class);
    private static MutableObject<String> newestLibPackage = (MutableObject)SharedReference.get("mclib", "newestLibPackage", MutableObject.class);
    private static String thisLibPackage;

    public static void register(MCLib mcLib) {
        thisLibPackage = SharedLibHelper.getClassNameParent(mcLib.getClass().getCanonicalName(), 2);
        MCLib.LOGGER.trace("Registering package " + thisLibPackage);
        existingLibPackages.add(thisLibPackage);
    }

    private static String getClassNameParent(String name, int count) {
        CharSequence[] canonicalNameParts = name.split("\\.");
        canonicalNameParts = Arrays.copyOf(canonicalNameParts, canonicalNameParts.length - count);
        return String.join((CharSequence)".", canonicalNameParts);
    }

    public static void shareifyClass(Class<?> clazz) {
        for (Field f : clazz.getFields()) {
            int mod = f.getModifiers();
            if (!Modifier.isStatic(mod)) continue;
            try {
                Enhancer e = new Enhancer();
                e.setSuperclass(f.getType());
                e.setCallback(new SharedModuleMethodRedirector(f));
                Object obj = e.create();
                f.setAccessible(true);
                f.set(null, obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isNewestLib(MCLib mcLib) {
        return SharedLibHelper.getNewestLibPackage().equals(thisLibPackage);
    }

    private static String getNewestLibPackage() {
        if (!Loader.instance().hasReachedState(LoaderState.PREINITIALIZATION)) {
            throw new IllegalStateException("Shared module was called before mod construction phase ended, this is not allowed.");
        }
        if (newestLibPackage.getValue() == null) {
            String newestPkg = null;
            ComparableVersion newestVersion = null;
            for (String pkg : existingLibPackages) {
                try {
                    Class<?> otherMcLibClass = Class.forName(pkg + "." + SharedLibHelper.toRelativeClassName(MCLib.class.getCanonicalName()));
                    ComparableVersion otherVersion = new ComparableVersion((String)otherMcLibClass.getField("VERSION").get(null));
                    if (newestVersion != null && newestVersion.compareTo(otherVersion) >= 0) continue;
                    newestPkg = pkg;
                    newestVersion = otherVersion;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            MCLib.LOGGER.info("Latest version of MCLib present: " + newestVersion + " @ " + newestPkg);
            newestLibPackage.setValue(newestPkg);
        }
        return (String)newestLibPackage.getValue();
    }

    public static String toRelativeClassName(String className) {
        if (className.startsWith(thisLibPackage)) {
            return className.substring(thisLibPackage.length() + 1);
        }
        throw new IllegalArgumentException(className + " does not start with " + thisLibPackage);
    }

    public static Class<?> findNewestLibClass(Class<?> clazz) {
        try {
            return Class.forName(SharedLibHelper.getNewestLibPackage() + "." + SharedLibHelper.toRelativeClassName(clazz.getCanonicalName()));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

