/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.EnumUtils;

public class TableBuilder<C extends Enum, V> {
    private List<C> entryKeys = new ArrayList<C>();
    private List<V> entryValues = new ArrayList<V>();

    public void set(C column, V value) {
        this.entryKeys.add(column);
        this.entryValues.add(value);
    }

    public void endRow() {
        if (!this.entryKeys.isEmpty()) {
            this.entryKeys.add(null);
            this.entryValues.add(null);
        }
    }

    public void writeToCSV(File file) throws IOException {
        List vals = EnumUtils.getEnumList(((Enum)this.entryKeys.get(0)).getClass());
        try (FileWriter writer = new FileWriter(file);){
            writer.write(String.join((CharSequence)",", (CharSequence[])vals.stream().map(String::valueOf).toArray(String[]::new)) + "\n");
            HashMap<Enum, V> row = new HashMap<Enum, V>();
            Object[] rowValues = new String[vals.size()];
            for (int entryI = 0; entryI < this.entryKeys.size(); ++entryI) {
                Enum key = (Enum)this.entryKeys.get(entryI);
                V value = this.entryValues.get(entryI);
                if (key == null) {
                    for (int valI = 0; valI < vals.size(); ++valI) {
                        Enum rowKey = (Enum)vals.get(valI);
                        Object rowValue = row.get(rowKey);
                        rowValues[valI] = rowValue != null ? String.valueOf(rowValue) : "";
                    }
                    writer.write(String.join((CharSequence)",", (CharSequence[])rowValues) + "\n");
                    row.clear();
                    Arrays.fill(rowValues, null);
                    continue;
                }
                row.put(key, value);
            }
        }
    }
}

