/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.defaultkeys;

import com.google.common.collect.ArrayListMultimap;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.blay09.mods.defaultkeys.DefaultKeys;
import net.blay09.mods.defaultkeys.localconfig.ForgeConfigHandler;
import net.blay09.mods.defaultkeys.localconfig.INIConfigHandler;
import net.blay09.mods.defaultkeys.localconfig.LocalConfigEntry;
import net.blay09.mods.defaultkeys.localconfig.SimpleConfigHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.event.GuiOpenEvent;
import org.apache.commons.io.IOUtils;

public class EventHandler {
    private static boolean initialized;
    private static Map<String, Integer> defaultKeys;
    private static List<String> knownKeys;

    EventHandler() {
    }

    @SubscribeEvent
    public void finishMinecraftLoading(GuiOpenEvent event) {
        if (!initialized && event.gui instanceof GuiMainMenu) {
            EventHandler.reloadDefaultMappings();
            initialized = true;
        }
    }

    static void preStartGame() {
        File modpackUpdate;
        File exampleConfigDefs;
        File localConfigDefs;
        File optionsFileOF;
        File mcDataDir = Minecraft.func_71410_x().field_71412_D;
        File optionsFile = new File(mcDataDir, "options.txt");
        if (!optionsFile.exists()) {
            EventHandler.applyDefaultOptions();
        }
        if (!(optionsFileOF = new File(mcDataDir, "optionsof.txt")).exists()) {
            EventHandler.applyDefaultOptionsOptiFine();
        }
        if (!(localConfigDefs = new File(mcDataDir, "config/localconfig.txt")).exists()) {
            try (InputStreamReader reader = new InputStreamReader(EventHandler.class.getResourceAsStream("/assets/defaultkeys/default-localconfig.txt"));
                 FileWriter writer = new FileWriter(localConfigDefs);){
                IOUtils.copy((Reader)reader, (Writer)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!(exampleConfigDefs = new File(mcDataDir, "config/localconfig-example.txt")).exists()) {
            try (InputStreamReader reader = new InputStreamReader(EventHandler.class.getResourceAsStream("/assets/defaultkeys/example-localconfig.txt"));
                 FileWriter writer = new FileWriter(exampleConfigDefs);){
                IOUtils.copy((Reader)reader, (Writer)writer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((modpackUpdate = new File(mcDataDir, "config/modpack-update")).exists()) {
            if (EventHandler.restoreLocalConfig()) {
                try {
                    Files.delete(modpackUpdate.toPath());
                }
                catch (Exception e) {
                    DefaultKeys.logger.error("Could not delete modpack-update file. Delete manually or configs will keep restoring to this point.", (Throwable)e);
                }
            }
        } else {
            EventHandler.backupLocalConfig();
        }
    }

    private static boolean backupLocalConfig() {
        DefaultKeys.logger.info("Backing up local config values...");
        File mcDataDir = Minecraft.func_71410_x().field_71412_D;
        File localConfigFile = new File(mcDataDir, "config/localconfig.txt");
        if (localConfigFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(localConfigFile));
                 PrintWriter writer = new PrintWriter(new File(mcDataDir, "localconfig.cfg"));){
                String line;
                writer.println("# This file is automatically generated on each startup.");
                writer.println("# You don't want to change anything in here as it'll get overriden anyways.");
                writer.println("# Just leave this file be and go edit the respective config files instead.");
                writer.println();
                ArrayList<LocalConfigEntry> entries = new ArrayList<LocalConfigEntry>();
                while ((line = reader.readLine()) != null) {
                    LocalConfigEntry entry = LocalConfigEntry.fromString(line, false);
                    if (entry == null) continue;
                    entries.add(entry);
                }
                ArrayListMultimap fileEntries = ArrayListMultimap.create();
                for (LocalConfigEntry entry : entries) {
                    fileEntries.put((Object)(entry.file + "//" + entry.getFormat()), (Object)entry);
                }
                block24: for (String key : fileEntries.keySet()) {
                    List list = fileEntries.get((Object)key);
                    LocalConfigEntry first = (LocalConfigEntry)list.get(0);
                    File configFile = new File(mcDataDir, "config/" + first.file);
                    if (!configFile.exists()) {
                        DefaultKeys.logger.warn("Skipping entry for {}: file at {} not found", new Object[]{first.getIdentifier(), configFile});
                        continue;
                    }
                    switch (first.getFormat()) {
                        case "forge": {
                            ForgeConfigHandler.backup(writer, list, configFile);
                            continue block24;
                        }
                        case "simple": {
                            SimpleConfigHandler.backup(writer, list, configFile);
                            continue block24;
                        }
                        case "ini": {
                            INIConfigHandler.backup(writer, list, configFile);
                            continue block24;
                        }
                    }
                    DefaultKeys.logger.error("Skipping entry for {}: unknown format {}", new Object[]{first.getIdentifier(), first.getFormat()});
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private static boolean restoreLocalConfig() {
        DefaultKeys.logger.info("Restoring local config values...");
        File mcDataDir = Minecraft.func_71410_x().field_71412_D;
        File localConfigDefinitionsFile = new File(mcDataDir, "config/localconfig.txt");
        File localConfigValuesFile = new File(mcDataDir, "localconfig.cfg");
        if (localConfigDefinitionsFile.exists() && localConfigValuesFile.exists()) {
            try (BufferedReader defReader = new BufferedReader(new FileReader(localConfigDefinitionsFile));
                 BufferedReader valReader = new BufferedReader(new FileReader(localConfigValuesFile));){
                String line;
                ArrayList<LocalConfigEntry> defEntries = new ArrayList<LocalConfigEntry>();
                while ((line = defReader.readLine()) != null) {
                    LocalConfigEntry entry = LocalConfigEntry.fromString(line, false);
                    if (entry == null) continue;
                    defEntries.add(entry);
                }
                ArrayList<LocalConfigEntry> entries = new ArrayList<LocalConfigEntry>();
                block23: while ((line = valReader.readLine()) != null) {
                    LocalConfigEntry entry = LocalConfigEntry.fromString(line, true);
                    if (entry == null) continue;
                    for (LocalConfigEntry defEntry : defEntries) {
                        if (!defEntry.file.equals(entry.file) || !defEntry.passesProperty(entry.category, entry.name, entry.type)) continue;
                        entry.parameters.putAll(defEntry.parameters);
                        entries.add(entry);
                        continue block23;
                    }
                }
                ArrayListMultimap fileEntries = ArrayListMultimap.create();
                for (LocalConfigEntry entry : entries) {
                    fileEntries.put((Object)(entry.file + "//" + entry.getFormat()), (Object)entry);
                }
                block26: for (String key : fileEntries.keySet()) {
                    List list = fileEntries.get((Object)key);
                    LocalConfigEntry first = (LocalConfigEntry)list.get(0);
                    File configFile = new File(mcDataDir, "config/" + first.file);
                    if (!configFile.exists()) {
                        DefaultKeys.logger.warn("Skipping entry for {}: file at {} not found", new Object[]{first.getIdentifier(), configFile});
                        continue;
                    }
                    switch (first.getFormat()) {
                        case "forge": {
                            ForgeConfigHandler.restore(list, configFile);
                            continue block26;
                        }
                        case "simple": {
                            SimpleConfigHandler.restore(list, configFile);
                            continue block26;
                        }
                        case "ini": {
                            INIConfigHandler.restore(list, configFile);
                            continue block26;
                        }
                    }
                    DefaultKeys.logger.error("Skipping entry for {}: unknown format {}", new Object[]{first.getIdentifier(), first.getFormat()});
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private static boolean applyDefaultOptions() {
        File defaultOptionsFile = new File(Minecraft.func_71410_x().field_71412_D, "config/defaultoptions.txt");
        if (defaultOptionsFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(defaultOptionsFile));
                 PrintWriter writer = new PrintWriter(new FileWriter(new File(Minecraft.func_71410_x().field_71412_D, "options.txt")));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("key_")) continue;
                    writer.println(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private static boolean applyDefaultOptionsOptiFine() {
        File defaultOptionsFile = new File(Minecraft.func_71410_x().field_71412_D, "config/defaultoptionsof.txt");
        if (defaultOptionsFile.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(defaultOptionsFile));
                 PrintWriter writer = new PrintWriter(new FileWriter(new File(Minecraft.func_71410_x().field_71412_D, "optionsof.txt")));){
                String line;
                while ((line = reader.readLine()) != null) {
                    writer.println(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    static boolean saveDefaultOptionsOptiFine() {
        if (!FMLClientHandler.instance().hasOptifine()) {
            return true;
        }
        Minecraft.func_71410_x().field_71474_y.func_74303_b();
        try (PrintWriter writer = new PrintWriter(new FileWriter(new File(Minecraft.func_71410_x().field_71412_D, "config/defaultoptionsof.txt")));
             BufferedReader reader = new BufferedReader(new FileReader(new File(Minecraft.func_71410_x().field_71412_D, "optionsof.txt")));){
            String line;
            while ((line = reader.readLine()) != null) {
                writer.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    static boolean saveDefaultOptions() {
        Minecraft.func_71410_x().field_71474_y.func_74303_b();
        try (PrintWriter writer = new PrintWriter(new FileWriter(new File(Minecraft.func_71410_x().field_71412_D, "config/defaultoptions.txt")));
             BufferedReader reader = new BufferedReader(new FileReader(new File(Minecraft.func_71410_x().field_71412_D, "options.txt")));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("key_")) continue;
                writer.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    static boolean saveDefaultMappings() {
        try (PrintWriter writer = new PrintWriter(new FileWriter(new File(Minecraft.func_71410_x().field_71412_D, "config/defaultkeys.txt")));){
            for (KeyBinding keyBinding : Minecraft.func_71410_x().field_71474_y.field_74324_K) {
                writer.println("key_" + keyBinding.func_151464_g() + ":" + keyBinding.func_151463_i());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    static void reloadDefaultMappings() {
        File knownKeysFile;
        block30: {
            defaultKeys.clear();
            knownKeys.clear();
            File defaultKeysFile = new File(Minecraft.func_71410_x().field_71412_D, "config/defaultkeys.txt");
            if (defaultKeysFile.exists()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(defaultKeysFile));
                    block23: while (true) {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            String[] s;
                            if (line.isEmpty() || (s = line.split(":")).length != 2 || !s[0].startsWith("key_")) continue;
                            try {
                                defaultKeys.put(s[0].substring(4), Integer.parseInt(s[1]));
                                continue block23;
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                        break block30;
                        {
                            continue block23;
                            break;
                        }
                        break;
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if ((knownKeysFile = new File(Minecraft.func_71410_x().field_71412_D, "knownkeys.txt")).exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(knownKeysFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    knownKeys.add(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (KeyBinding keyBinding : Minecraft.func_71410_x().field_71474_y.field_74324_K) {
            if (!defaultKeys.containsKey(keyBinding.func_151464_g())) continue;
            keyBinding.field_151472_e = defaultKeys.get(keyBinding.func_151464_g());
            if (knownKeys.contains(keyBinding.func_151464_g())) continue;
            keyBinding.func_151462_b(keyBinding.func_151469_h());
            knownKeys.add(keyBinding.func_151464_g());
        }
        KeyBinding.func_74508_b();
        try (PrintWriter writer = new PrintWriter(new FileWriter(new File(Minecraft.func_71410_x().field_71412_D, "knownkeys.txt")));){
            for (String s : knownKeys) {
                writer.println(s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        defaultKeys = new HashMap<String, Integer>();
        knownKeys = new ArrayList<String>();
    }
}

