/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.multipart.microblock;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.MicroMaterialRegistry;
import codechicken.microblock.MicroblockRender;
import codechicken.multipart.MultipartGenerator;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import com.rwtema.extrautils.multipart.microblock.IFence;
import com.rwtema.extrautils.multipart.microblock.PartConnecting;
import com.rwtema.extrautils.multipart.microblock.PartFenceDummyArm;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Facing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class PartFence
extends PartConnecting
implements IFence {
    public static final Cuboid6[] partCuboids = new Cuboid6[]{new Cuboid6(0.375, 0.0, 0.375, 0.625, 1.0, 0.625), new Cuboid6(0.375, 0.0, 0.375, 0.625, 1.5, 0.625), new Cuboid6(0.375, 0.0, 0.0, 0.625, 1.5, 0.375), new Cuboid6(0.375, 0.0, 0.625, 0.625, 1.5, 1.0), new Cuboid6(0.0, 0.0, 0.375, 0.375, 1.5, 0.625), new Cuboid6(0.625, 0.0, 0.375, 1.0, 1.5, 0.625)};
    public static final Cuboid6[] renderCuboids1 = new Cuboid6[]{null, null, new Cuboid6(0.4375, 0.75, 0.0, 0.5625, 0.9375, 0.375), new Cuboid6(0.4375, 0.75, 0.625, 0.5625, 0.9375, 1.0), new Cuboid6(0.0, 0.75, 0.4375, 0.375, 0.9375, 0.5625), new Cuboid6(0.625, 0.75, 0.4375, 1.0, 0.9375, 0.5625)};
    public static final Cuboid6[] renderCuboids2 = new Cuboid6[]{null, null, new Cuboid6(0.4375, 0.375, 0.0, 0.5625, 0.5625, 0.375), new Cuboid6(0.4375, 0.375, 0.625, 0.5625, 0.5625, 1.0), new Cuboid6(0.0, 0.375, 0.4375, 0.375, 0.5625, 0.5625), new Cuboid6(0.625, 0.375, 0.4375, 1.0, 0.5625, 0.5625)};
    public static final String type = "extrautils:fence";

    public PartFence() {
    }

    public PartFence(int material) {
        super(material);
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public Cuboid6 getBounds() {
        return partCuboids[0];
    }

    @Override
    public Iterable<Cuboid6> getCollisionBoxes() {
        ArrayList<Cuboid6> t = new ArrayList<Cuboid6>();
        if (this.isEthereal()) {
            return t;
        }
        t.add(partCuboids[1].copy());
        for (int i = 2; i < 6; ++i) {
            if ((this.connectionMask & 1 << i) == 0) continue;
            t.add(partCuboids[i].copy());
        }
        return t;
    }

    @Override
    public boolean shouldConnect(int x, int y, int z, int direction) {
        Block l = this.world().func_147439_a(x, y, z);
        if (this.world().func_147438_o(x, y, z) instanceof IFence && this.tile().canAddPart((TMultiPart)PartFenceDummyArm.dummyArms[direction])) {
            return ((TileMultipart)this.world().func_147438_o(x, y, z)).canAddPart((TMultiPart)PartFenceDummyArm.dummyArms[Facing.field_71588_a[direction]]);
        }
        return l.func_149688_o().func_76218_k() && l.func_149686_d() && this.tile().canAddPart((TMultiPart)PartFenceDummyArm.dummyArms[direction]);
    }

    @Override
    public void reloadShape() {
        int prevMask = this.connectionMask;
        this.connectionMask = 0;
        for (int i = 2; i < 6; ++i) {
            if (!this.shouldConnect(this.x() + Facing.field_71586_b[i], this.y() + Facing.field_71587_c[i], this.z() + Facing.field_71585_d[i], i)) continue;
            this.connectionMask |= 1 << i;
        }
        if (prevMask != this.connectionMask) {
            this.tile().notifyPartChange((TMultiPart)this);
            this.tile().markRender();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vector3 pos, int pass) {
        this.reloadShape();
        if (this.mat == null) {
            this.mat = MicroMaterialRegistry.getMaterial((int)this.material);
        }
        if (this.mat != null && this.mat.canRenderInPass(pass)) {
            MicroblockRender.renderCuboid((Vector3)new Vector3((double)this.x(), (double)this.y(), (double)this.z()), (MicroMaterialRegistry.IMicroMaterial)this.mat, (int)pass, (Cuboid6)this.getRenderBounds(), (int)0);
            for (int i = 0; i < 6; ++i) {
                if ((this.connectionMask & 1 << i) == 0) continue;
                MicroblockRender.renderCuboid((Vector3)new Vector3((double)this.x(), (double)this.y(), (double)this.z()), (MicroMaterialRegistry.IMicroMaterial)this.mat, (int)pass, (Cuboid6)renderCuboids1[i], (int)(1 << Facing.field_71588_a[i] | 1 << i));
                MicroblockRender.renderCuboid((Vector3)new Vector3((double)this.x(), (double)this.y(), (double)this.z()), (MicroMaterialRegistry.IMicroMaterial)this.mat, (int)pass, (Cuboid6)renderCuboids2[i], (int)(1 << Facing.field_71588_a[i] | 1 << i));
            }
            return true;
        }
        return false;
    }

    @Override
    public float getStrength(MovingObjectPosition hit, EntityPlayer player) {
        return this.getMaterial().getStrength(player);
    }

    @Override
    public int getMetadata() {
        return 1;
    }

    @Override
    public TMultiPart newPart(boolean client) {
        return new PartFence();
    }

    @Override
    public TMultiPart placePart(ItemStack stack, EntityPlayer player, World world, BlockCoord pos, int side, Vector3 arg5, int materialID) {
        return new PartFence(materialID);
    }

    @Override
    public void registerPassThroughs() {
        MultipartGenerator.registerPassThroughInterface((String)IFence.class.getName());
    }

    @Override
    public void renderItem(ItemStack item, MicroMaterialRegistry.IMicroMaterial material) {
        MicroblockRender.renderCuboid((Vector3)new Vector3(0.0, 0.0, 0.0), (MicroMaterialRegistry.IMicroMaterial)material, (int)-1, (Cuboid6)partCuboids[0], (int)0);
        MicroblockRender.renderCuboid((Vector3)new Vector3(0.0, 0.0, 0.0), (MicroMaterialRegistry.IMicroMaterial)material, (int)-1, (Cuboid6)renderCuboids1[2], (int)0);
        MicroblockRender.renderCuboid((Vector3)new Vector3(0.0, 0.0, 0.0), (MicroMaterialRegistry.IMicroMaterial)material, (int)-1, (Cuboid6)renderCuboids1[3], (int)0);
        MicroblockRender.renderCuboid((Vector3)new Vector3(0.0, 0.0, 0.0), (MicroMaterialRegistry.IMicroMaterial)material, (int)-1, (Cuboid6)renderCuboids2[2], (int)0);
        MicroblockRender.renderCuboid((Vector3)new Vector3(0.0, 0.0, 0.0), (MicroMaterialRegistry.IMicroMaterial)material, (int)-1, (Cuboid6)renderCuboids2[3], (int)0);
    }
}

