/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.network.packets;

import com.rwtema.extrautils.network.NetworkHandler;
import com.rwtema.extrautils.network.XUPacketBase;
import com.rwtema.extrautils.network.packets.PacketNEIPong;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class PacketNEIPing
extends XUPacketBase {
    private ItemStack itemStack;
    private EntityPlayer player;
    static WeakHashMap<EntityPlayer, Long> timeOutsHandler = new WeakHashMap();
    static final long TIMEOUT = 10L;
    static final int RANGE = 16;

    public PacketNEIPing() {
    }

    public PacketNEIPing(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public void writeData(ByteBuf data) throws Exception {
        this.writeItemStack(data, this.itemStack);
    }

    @Override
    public void readData(EntityPlayer player, ByteBuf data) {
        this.player = player;
        this.itemStack = this.readItemStack(data);
    }

    @Override
    public void doStuffServer(ChannelHandlerContext ctx) {
        if (this.player == null || this.itemStack == null || this.itemStack.func_77973_b() == null) {
            return;
        }
        World world = this.player.field_70170_p;
        long time = world.func_82737_E();
        Long aLong = timeOutsHandler.get(this.player);
        if (aLong != null && time - aLong < 10L) {
            return;
        }
        timeOutsHandler.put(this.player, time);
        final int x = (int)Math.round(this.player.field_70165_t);
        final int y = (int)Math.round(this.player.field_70163_u);
        final int z = (int)Math.round(this.player.field_70161_v);
        Item trueItem = this.itemStack.func_77973_b();
        int trueItemDamage = this.itemStack.func_77960_j();
        TreeSet<ChunkPosition> positions = new TreeSet<ChunkPosition>(new Comparator<ChunkPosition>(){

            @Override
            public int compare(ChunkPosition o1, ChunkPosition o2) {
                return Double.compare(PacketNEIPing.this.getRange(x, y, z, o1), PacketNEIPing.this.getRange(x, y, z, o2));
            }
        });
        for (int cx = x - 16; cx <= x + 16; cx += 16) {
            for (int cz = z - 16; cz <= z + 16; cz += 16) {
                if (!world.func_72899_e(cx, y, cz)) continue;
                Chunk chunk = world.func_72938_d(cx, cz);
                Set entrySet = chunk.field_150816_i.entrySet();
                block2: for (Map.Entry entry2 : entrySet) {
                    Object value;
                    ChunkPosition e = (ChunkPosition)entry2.getKey();
                    ChunkPosition key = new ChunkPosition(chunk.field_76635_g * 16 + e.field_151329_a, e.field_151327_b, chunk.field_76647_h * 16 + e.field_151328_c);
                    if (!this.inRange(x, y, z, key) || !((value = entry2.getValue()) instanceof IInventory)) continue;
                    IInventory inv = (IInventory)value;
                    for (int i = 0; i < inv.func_70302_i_(); ++i) {
                        ItemStack stackInSlot = inv.func_70301_a(i);
                        if (stackInSlot == null || stackInSlot.func_77973_b() != trueItem || trueItem.func_77614_k() && stackInSlot.func_77960_j() != trueItemDamage) continue;
                        positions.add(key);
                        if (positions.size() < 20) continue block2;
                        positions.pollLast();
                        continue block2;
                    }
                }
            }
        }
        if (!positions.isEmpty()) {
            NetworkHandler.sendPacketToPlayer(new PacketNEIPong(new ArrayList<ChunkPosition>(positions)), this.player);
        }
    }

    public int getRange(int x, int y, int z, ChunkPosition pos) {
        return Math.abs(pos.field_151329_a - x) + Math.abs(pos.field_151327_b - y) + Math.abs(pos.field_151328_c - z);
    }

    public boolean inRange(int x, int y, int z, ChunkPosition pos) {
        return Math.abs(pos.field_151329_a - x) <= 16 && Math.abs(pos.field_151327_b - y) <= 16 && Math.abs(pos.field_151328_c - z) <= 16;
    }

    @Override
    public void doStuffClient() {
    }

    @Override
    public boolean isValidSenderSide(Side properSenderSide) {
        return properSenderSide.isClient();
    }
}

