/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.sounds;

import com.rwtema.extrautils.sounds.Sounds;
import com.rwtema.extrautils.tileentity.generators.TileEntityGenerator;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class XUSoundTileGenerators
implements ITickableSound {
    private static WeakReference<XUSoundTileGenerators> instance = null;
    private WeakHashMap<TileEntityGenerator, Void> tiles = new WeakHashMap();
    private boolean donePlaying = false;
    private float zPosF = 0.0f;
    private float xPosF = 0.0f;
    private float yPosF = 0.0f;
    private float volume = 1.0E-6f;
    private ResourceLocation location = TileEntityGenerator.hum;

    private static XUSoundTileGenerators getInstance() {
        XUSoundTileGenerators sound;
        XUSoundTileGenerators xUSoundTileGenerators = sound = instance != null ? (XUSoundTileGenerators)instance.get() : null;
        if (sound == null) {
            sound = new XUSoundTileGenerators();
            instance = new WeakReference<XUSoundTileGenerators>(sound);
        }
        return sound;
    }

    private static void clearInstance() {
        instance = null;
    }

    public boolean func_147667_k() {
        return this.donePlaying;
    }

    public ResourceLocation func_147650_b() {
        return this.location;
    }

    public boolean func_147657_c() {
        return true;
    }

    public int func_147652_d() {
        return 0;
    }

    public float func_147653_e() {
        return this.volume;
    }

    public float func_147655_f() {
        return 1.0f;
    }

    public float func_147649_g() {
        return this.xPosF;
    }

    public float func_147654_h() {
        return this.yPosF;
    }

    public float func_147651_i() {
        return this.zPosF;
    }

    public ISound.AttenuationType func_147656_j() {
        return ISound.AttenuationType.LINEAR;
    }

    @SideOnly(value=Side.CLIENT)
    public static void addGenerator(TileEntityGenerator generator) {
        XUSoundTileGenerators instance1 = XUSoundTileGenerators.getInstance();
        XUSoundTileGenerators.removeOldValues();
        if (!instance1.tiles.containsKey(generator)) {
            instance1.tiles.put(generator, null);
            if (instance1.tiles.size() == 1) {
                XUSoundTileGenerators.refresh();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void refresh() {
        if (instance == null || instance.get() == null) {
            return;
        }
        XUSoundTileGenerators sound = XUSoundTileGenerators.getInstance();
        if (!sound.tiles.isEmpty()) {
            XUSoundTileGenerators.removeOldValues();
            if (!sound.tiles.isEmpty() && Sounds.canAddSound((ISound)sound)) {
                sound.setDonePlaying(false);
                sound.volume = 1.0E-7f;
                Sounds.tryAddSound((ISound)sound);
            }
        }
    }

    private static void removeOldValues() {
        WeakHashMap<TileEntityGenerator, Void> weakHashMap = XUSoundTileGenerators.getInstance().tiles;
        Iterator<TileEntityGenerator> iter = weakHashMap.keySet().iterator();
        while (iter.hasNext()) {
            TileEntityGenerator gen = iter.next();
            if (gen != null && !gen.func_145837_r() && gen.func_145831_w() == Minecraft.func_71410_x().field_71441_e) continue;
            iter.remove();
        }
    }

    public synchronized void func_73660_a() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            this.setDonePlaying(true);
            return;
        }
        XUSoundTileGenerators.removeOldValues();
        if (this.tiles.size() == 0) {
            if ((double)this.volume > 5.0E-4) {
                this.volume *= 0.9f;
            } else {
                this.setDonePlaying(true);
            }
        } else {
            boolean shouldPlay = false;
            if (this.tiles.size() == 1) {
                for (TileEntityGenerator gen : this.tiles.keySet()) {
                    if (!gen.shouldSoundPlay()) continue;
                    shouldPlay = true;
                    this.moveTorwards((float)gen.x() + 0.5f, (float)gen.y() + 0.5f, (float)gen.z() + 0.5f, 0.05f);
                }
            } else {
                float x = 0.0f;
                float y = 0.0f;
                float z = 0.0f;
                float total_weight = 0.0f;
                for (TileEntityGenerator gen : this.tiles.keySet()) {
                    if (gen == null || !gen.shouldSoundPlay()) continue;
                    shouldPlay = true;
                    float w = XUSoundTileGenerators.weight(gen.func_145835_a(player.field_70165_t, player.field_70163_u, player.field_70161_v));
                    x += w * (float)gen.x();
                    y += w * (float)gen.y();
                    z += w * (float)gen.z();
                    total_weight += w;
                }
                if (shouldPlay && total_weight > 0.0f) {
                    this.moveTorwards(x / total_weight + 0.5f, y / total_weight + 0.5f, z / total_weight + 0.5f, 0.05f);
                } else {
                    this.volume *= 0.9f;
                }
            }
            this.volume = shouldPlay ? ((double)this.volume < 0.9995 ? 1.0f - (1.0f - this.volume) * 0.9f : 1.0f) : ((double)this.volume > 5.0E-4 ? (this.volume *= 0.9f) : 0.0f);
        }
    }

    private void moveTorwards(float x, float y, float z, float speed) {
        if (this.volume == 0.0f) {
            speed = 1.0f;
        }
        this.xPosF = this.xPosF * (1.0f - speed) + x * speed;
        this.yPosF = this.yPosF * (1.0f - speed) + y * speed;
        this.zPosF = this.zPosF * (1.0f - speed) + z * speed;
    }

    private static float weight(double d) {
        if (d < 1.0) {
            return 1.0f;
        }
        return (float)(1.0 / d);
    }

    public void setDonePlaying(boolean donePlaying) {
        this.donePlaying = donePlaying;
        if (donePlaying) {
            XUSoundTileGenerators.clearInstance();
        }
    }
}

