/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.generators;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import com.rwtema.extrautils.sounds.ISoundTile;
import com.rwtema.extrautils.sounds.Sounds;
import com.rwtema.extrautils.tileentity.generators.BlockGenerator;
import com.rwtema.extrautils.tileentity.generators.InventoryGeneric;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;

public class TileEntityGenerator
extends TileEntity
implements IEnergyHandler,
ISoundTile {
    public static final int capacity = 100000;
    public EnergyStorage storage = new EnergyStorage(100000);
    public byte rotation = 0;
    public double coolDown = 0.0;
    int c = -1;
    public boolean initPower = true;
    public boolean playSound = false;
    private int multiplier = -1;
    private double divisor = -1.0;
    public static ResourceLocation hum = new ResourceLocation("extrautils", "ambient.hum");
    private boolean shouldInit = true;

    public EnergyStorage getStorage() {
        if (this.initPower && this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.field_145850_b.func_72899_e(this.x(), this.y(), this.z())) {
            this.initPower = false;
            this.storage.setCapacity(100000 * this.getMultiplier());
            this.storage.setMaxTransfer(100000 * this.getMultiplier());
        }
        return this.storage;
    }

    public int getMultiplier() {
        if (this.multiplier == -1) {
            Block b = this.func_145838_q();
            this.multiplier = b instanceof BlockGenerator ? ((BlockGenerator)b).numGenerators : 1;
        }
        return this.multiplier;
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public double getDivisor() {
        if (this.divisor == -1.0) {
            this.divisor = 1.0 / (double)this.getMultiplier();
        }
        return this.divisor;
    }

    public static int getFurnaceBurnTime(ItemStack item) {
        if (item == null) {
            return 0;
        }
        if (item.func_77973_b() == Items.field_151129_at) {
            return 0;
        }
        return TileEntityFurnace.func_145952_a((ItemStack)item);
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    @Override
    public ResourceLocation getSound() {
        return hum;
    }

    @Override
    public boolean shouldSoundPlay() {
        return this.playSound;
    }

    public static String getCoolDownString(double time) {
        String s = String.format("%.1f", time % 60.0) + "s";
        int t = (int)time / 60;
        if (t == 0) {
            return s;
        }
        s = t % 60 + "m " + s;
        if ((t /= 60) == 0) {
            return s;
        }
        s = t % 24 + "h " + s;
        if ((t /= 24) == 0) {
            return s;
        }
        s = t + "d " + s;
        return s;
    }

    public int x() {
        return this.field_145851_c;
    }

    public int y() {
        return this.field_145848_d;
    }

    public int z() {
        return this.field_145849_e;
    }

    public boolean isPowered() {
        return this.field_145850_b.func_72864_z(this.x(), this.y(), this.z());
    }

    public String getBlurb(double coolDown, double energy) {
        if (coolDown == 0.0) {
            return "";
        }
        return "PowerLevel:\n" + String.format("%.1f", energy) + "\nTime Remaining:\n" + TileEntityGenerator.getCoolDownString(coolDown);
    }

    public double stepCoolDown() {
        return 1.0;
    }

    public int getCompLevel() {
        if (this.c == -1) {
            this.c = this.getStorage().getEnergyStored() * 15 / this.getStorage().getMaxEnergyStored();
        }
        return this.c;
    }

    public void checkCompLevel() {
        if (this.getCompLevel() != this.getStorage().getEnergyStored() * 15 / this.getStorage().getMaxEnergyStored()) {
            this.c = this.getStorage().getEnergyStored() * 15 / this.getStorage().getMaxEnergyStored();
            this.field_145850_b.func_147459_d(this.x(), this.y(), this.z(), this.func_145838_q());
        }
    }

    public boolean shouldProcess() {
        return false;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            if (this.shouldInit) {
                this.shouldInit = false;
                Sounds.addGenerator(this);
            }
            return;
        }
        if (this.coolDown > 0.0) {
            if (this.coolDown > 1.0) {
                this.getStorage().receiveEnergy((int)Math.floor(this.genLevel() * (double)this.getMultiplier()), false);
                this.coolDown -= this.stepCoolDown();
            } else {
                this.getStorage().receiveEnergy((int)Math.floor(this.coolDown * this.genLevel() * (double)this.getMultiplier()), false);
                this.coolDown = 0.0;
            }
        } else {
            this.coolDown = 0.0;
        }
        this.doSpecial();
        if (this.shouldProcess() && (this.getStorage().getEnergyStored() == 0 || (double)this.getStorage().getEnergyStored() < Math.min((double)(this.getStorage().getMaxEnergyStored() - 1000), (double)this.getStorage().getMaxEnergyStored() - (double)this.getMultiplier() * this.genLevel()))) {
            this.processInput();
        }
        if (this.coolDown > 0.0 != this.playSound) {
            this.field_145850_b.func_147471_g(this.x(), this.y(), this.z());
            boolean bl = this.playSound = this.coolDown > 0.0;
        }
        if (this.shouldTransmit() && this.getStorage().getEnergyStored() > 0) {
            this.transmitEnergy();
        }
        this.checkCompLevel();
    }

    public void doSpecial() {
    }

    @SideOnly(value=Side.CLIENT)
    public void doRandomDisplayTickR(Random random) {
    }

    private void transmitEnergy() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.field_145850_b.func_147438_o(this.x() + side.offsetX, this.y() + side.offsetY, this.z() + side.offsetZ);
            if (tile instanceof TileEntityGenerator || !(tile instanceof IEnergyReceiver)) continue;
            this.getStorage().extractEnergy(((IEnergyReceiver)tile).receiveEnergy(side.getOpposite(), this.getStorage().extractEnergy(this.transferLimit() * this.getMultiplier(), true), false), false);
        }
    }

    public int transferLimit() {
        return this.getStorage().getMaxEnergyStored();
    }

    public boolean shouldTransmit() {
        return true;
    }

    public int getMaxCoolDown() {
        return 200;
    }

    public double getNerfVisor() {
        if (this.getMultiplier() == 1) {
            return 1.0;
        }
        if (this.getMultiplier() <= 8) {
            return 1.0;
        }
        return 1.0;
    }

    public final boolean addCoolDown(double coolDown, boolean simulate) {
        if (!simulate) {
            this.coolDown += coolDown * this.getDivisor() * this.getNerfVisor();
        }
        return true;
    }

    public boolean processInput() {
        return false;
    }

    public double genLevel() {
        return 0.0;
    }

    public FluidTank[] getTanks() {
        return new FluidTank[0];
    }

    public InventoryGeneric getInventory() {
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int energy = nbt.func_74762_e("Energy");
        if (energy > this.storage.getMaxEnergyStored()) {
            this.storage.setCapacity(energy);
            this.initPower = true;
        }
        this.storage.setEnergyStored(energy);
        if (this.getInventory() != null) {
            this.getInventory().readFromNBT(nbt);
        }
        if (this.getTanks() != null) {
            for (int i = 0; i < this.getTanks().length; ++i) {
                this.getTanks()[i].readFromNBT(nbt.func_74775_l("Tank_" + i));
            }
        }
        this.rotation = (byte)nbt.func_74762_e("rotation");
        this.coolDown = nbt.func_74769_h("coolDown");
        this.playSound = this.coolDown > 0.0;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        this.getStorage().writeToNBT(nbt);
        if (this.getInventory() != null) {
            this.getInventory().writeToNBT(nbt);
        }
        if (this.getTanks() != null) {
            for (int i = 0; i < this.getTanks().length; ++i) {
                NBTTagCompound t = new NBTTagCompound();
                this.getTanks()[i].writeToNBT(t);
                nbt.func_74782_a("Tank_" + i, (NBTBase)t);
            }
        }
        nbt.func_74768_a("rotation", (int)this.rotation);
        nbt.func_74780_a("coolDown", this.coolDown);
        super.func_145841_b(nbt);
        NBTTagCompound backup = new NBTTagCompound();
        super.func_145841_b(backup);
        nbt.func_74782_a("backup", (NBTBase)backup);
    }

    public Packet func_145844_m() {
        NBTTagCompound t = new NBTTagCompound();
        t.func_74774_a("d", this.rotation);
        t.func_74757_a("s", this.coolDown > 0.0);
        this.playSound = this.coolDown > 0.0;
        return new S35PacketUpdateTileEntity(this.x(), this.y(), this.z(), 4, t);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        NBTTagCompound tags = pkt.func_148857_g();
        if (tags.func_74764_b("d")) {
            if (tags.func_74771_c("d") != this.rotation) {
                this.field_145850_b.func_147471_g(this.x(), this.y(), this.z());
            }
            this.rotation = tags.func_74771_c("d");
        }
        if (tags.func_74764_b("s")) {
            this.playSound = tags.func_74767_n("s");
            Sounds.refresh();
        }
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.shouldTransmit() ? this.getStorage().extractEnergy(Math.min(this.transferLimit() * this.getMultiplier(), maxExtract), simulate) : 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.getStorage().getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getStorage().getMaxEnergyStored();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int c = 0;
        for (FluidTank tank : this.getTanks()) {
            c += tank.fill(resource, doFill);
        }
        return c;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] info = new FluidTankInfo[this.getTanks().length];
        for (int i = 0; i < this.getTanks().length; ++i) {
            info[i] = this.getTanks()[i].getInfo();
        }
        return info;
    }

    public boolean canExtractItem(int i, ItemStack itemstack, int j) {
        return true;
    }

    public void readInvFromTags(NBTTagCompound tags) {
        if (tags.func_74764_b("Energy")) {
            this.getStorage().readFromNBT(tags);
        }
    }

    public void writeInvToTags(NBTTagCompound tags) {
        if (this.getStorage().getEnergyStored() > 0) {
            this.getStorage().writeToNBT(tags);
        }
    }
}

