/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.api;

import java.util.Random;
import makeo.gadomancy.api.GadomancyApi;
import net.minecraft.entity.Entity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;

public abstract class AuraEffect {
    public abstract EffectType getEffectType();

    public abstract boolean isEntityApplicable(Entity var1);

    public abstract void doEntityEffect(ChunkCoordinates var1, Entity var2);

    public abstract int getBlockCount(Random var1);

    public abstract void doBlockEffect(ChunkCoordinates var1, ChunkCoordinates var2, World var3);

    public int getTickInterval() {
        return 8;
    }

    public double getRange() {
        return 8.0;
    }

    public AuraEffect register(Aspect a) {
        GadomancyApi.registerAdditionalAuraEffect(a, this);
        return this;
    }

    public static enum EffectType {
        ENTITY_EFFECT,
        BLOCK_EFFECT;

    }

    public static abstract class BlockAuraEffect
    extends AuraEffect {
        @Override
        public final EffectType getEffectType() {
            return EffectType.BLOCK_EFFECT;
        }

        @Override
        public final boolean isEntityApplicable(Entity e) {
            return false;
        }

        @Override
        public final void doEntityEffect(ChunkCoordinates originTile, Entity e) {
        }
    }

    public static abstract class EntityAuraEffect
    extends AuraEffect {
        @Override
        public final EffectType getEffectType() {
            return EffectType.ENTITY_EFFECT;
        }

        @Override
        public abstract boolean isEntityApplicable(Entity var1);

        @Override
        public abstract void doEntityEffect(ChunkCoordinates var1, Entity var2);

        @Override
        public final int getBlockCount(Random random) {
            return 0;
        }

        @Override
        public final void doBlockEffect(ChunkCoordinates originTile, ChunkCoordinates selectedBlock, World world) {
        }
    }
}

