/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.client.transformation;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import makeo.gadomancy.client.renderers.entity.PlayerCameraRenderer;
import makeo.gadomancy.client.transformation.FakeEntityGolemBase;
import makeo.gadomancy.common.network.PacketHandler;
import makeo.gadomancy.common.network.packets.PacketAbortTransform;
import makeo.gadomancy.common.registration.RegisteredIntegrations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import thaumcraft.common.entities.golems.EntityGolemBase;

@SideOnly(value=Side.CLIENT)
public class TransformationHelper {
    private static final FakeEntityGolemBase DEFAULT_GOLEM;
    private static PlayerCameraRenderer renderer;
    private static Map<Integer, Integer> transformedPlayers;
    private static Map<Integer, FakeEntityGolemBase> entityCache;

    private TransformationHelper() {
    }

    public static boolean isTransformable() {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71439_g.equals((Object)mc.field_71451_h) && !RegisteredIntegrations.morph.isMorphed() && mc.field_71460_t.getClass().equals(EntityRenderer.class) && (renderer == null || renderer.isRemoved());
    }

    public static boolean isForeignTransformed() {
        Minecraft mc = Minecraft.func_71410_x();
        return !mc.field_71451_h.equals((Object)mc.field_71439_g) || RegisteredIntegrations.morph.isMorphed() || !mc.field_71460_t.getClass().equals(EntityRenderer.class) && !(mc.field_71460_t instanceof PlayerCameraRenderer);
    }

    public static boolean isTransformed() {
        return renderer != null && !renderer.isMarkedForRemoval();
    }

    public static boolean isTransformed(EntityPlayer player) {
        if (player.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            return TransformationHelper.isTransformed();
        }
        return TransformationHelper.getTransformedEntityId(player) != -1;
    }

    public static FakeEntityGolemBase getTransformedEntity(EntityPlayer player) {
        Integer entityId = transformedPlayers.get(player.func_145782_y());
        if (entityId != null) {
            EntityGolemBase rawGolem;
            FakeEntityGolemBase golem = entityCache.get(entityId);
            if (golem == null && (rawGolem = TransformationHelper.findGolem(entityId)) != null) {
                golem = new FakeEntityGolemBase(rawGolem, player);
                entityCache.put(entityId, golem);
            }
            if (golem != null) {
                return golem;
            }
        }
        return DEFAULT_GOLEM;
    }

    private static EntityGolemBase findGolem(int entityId) {
        List loaded = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_72910_y();
        for (int i = 0; i < loaded.size(); ++i) {
            Entity entity = (Entity)loaded.get(i);
            if (!(entity instanceof EntityGolemBase) || entity.func_145782_y() != entityId) continue;
            return (EntityGolemBase)entity;
        }
        return null;
    }

    public static FakeEntityGolemBase getTransformedEntity() {
        return TransformationHelper.getTransformedEntity((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    private static int getTransformedEntityId(EntityPlayer player) {
        Integer entityId = transformedPlayers.get(player.func_145782_y());
        return entityId == null ? -1 : entityId;
    }

    public static int getTransformedEntityId() {
        return TransformationHelper.getTransformedEntityId((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }

    public static void cancelTransformation(PacketAbortTransform.AbortReason reason) {
        if (TransformationHelper.isTransformed()) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketAbortTransform(reason));
            TransformationHelper.onAbortTransformation(Minecraft.func_71410_x().field_71439_g.func_145782_y());
        }
    }

    public static void onStartTransformation(int targetId, int appearanceId) {
        if (Minecraft.func_71410_x().field_71439_g.func_145782_y() == targetId) {
            if (TransformationHelper.isTransformable()) {
                transformedPlayers.put(targetId, appearanceId);
                Minecraft mc = Minecraft.func_71410_x();
                renderer = new PlayerCameraRenderer(mc, mc.field_71460_t);
                mc.field_71460_t = renderer;
            } else {
                TransformationHelper.cancelTransformation(PacketAbortTransform.AbortReason.TRANSFORMATION_FAILED);
            }
        } else {
            transformedPlayers.put(targetId, appearanceId);
        }
    }

    public static void onAbortTransformation(int targetId) {
        transformedPlayers.remove(targetId);
        entityCache.remove(targetId);
        if (Minecraft.func_71410_x().field_71439_g.func_145782_y() == targetId && TransformationHelper.isTransformed()) {
            renderer.markForRemoval();
        }
    }

    static {
        EntityGolemBase golem = new EntityGolemBase(null){

            public byte getCore() {
                return 4;
            }
        };
        DEFAULT_GOLEM = new FakeEntityGolemBase(golem, null);
        transformedPlayers = new HashMap<Integer, Integer>();
        entityCache = new HashMap<Integer, FakeEntityGolemBase>();
    }
}

