/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.blocks;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import makeo.gadomancy.common.blocks.IBlockTransparent;
import makeo.gadomancy.common.blocks.tiles.TileEssentiaCompressor;
import makeo.gadomancy.common.network.PacketHandler;
import makeo.gadomancy.common.network.packets.PacketStartAnimation;
import makeo.gadomancy.common.registration.RegisteredBlocks;
import makeo.gadomancy.common.registration.RegisteredItems;
import makeo.gadomancy.common.registration.RegisteredRecipes;
import makeo.gadomancy.common.research.SimpleResearchItem;
import makeo.gadomancy.common.utils.ExplosionHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.research.ResearchManager;

public class BlockEssentiaCompressor
extends BlockContainer
implements IBlockTransparent {
    private IIcon icon;

    public BlockEssentiaCompressor() {
        super(Material.field_151575_d);
        this.func_149711_c(5.0f);
        this.func_149752_b(20.0f);
        this.setHarvestLevel("axe", 1);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.func_149647_a(RegisteredItems.creativeTab);
    }

    protected String func_149641_N() {
        return "gadomancy:block_packed_compressor";
    }

    public int func_149645_b() {
        return RegisteredBlocks.rendererTransparentBlock;
    }

    public void func_149651_a(IIconRegister ir) {
        this.icon = ir.func_94245_a("gadomancy:transparent");
        super.func_149651_a(ir);
    }

    @Override
    public IIcon getTransparentIcon() {
        return this.icon;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null || !(te instanceof TileEssentiaCompressor)) {
            return 0;
        }
        if (((TileEssentiaCompressor)te).isMultiblockFormed() && ((TileEssentiaCompressor)te).isMasterTile()) {
            return 8;
        }
        return 0;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        super.func_149749_a(world, x, y, z, block, meta);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null || !(te instanceof TileEssentiaCompressor)) {
            return;
        }
        TileEssentiaCompressor compressor = (TileEssentiaCompressor)te;
        if (compressor.isMultiblockFormed()) {
            AspectList al = compressor.getAspects();
            if (al.visSize() > 0) {
                ExplosionHelper.taintplosion(world, x, y, z, true, 2, 2.0f, 4, 20);
                world.func_147468_f(x, y, z);
            } else {
                ExplosionHelper.taintplosion(world, x, y, z, false, 2, 2.0f, 4, 20);
                world.func_147468_f(x, y, z);
            }
        }
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null || !(te instanceof TileEssentiaCompressor)) {
            super.func_149719_a(world, x, y, z);
            return;
        }
        if (((TileEssentiaCompressor)te).isMultiblockFormed()) {
            if (((TileEssentiaCompressor)te).isMasterTile()) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 3.0f, 1.0f);
            } else {
                int yM = ((TileEssentiaCompressor)te).getMultiblockYIndex();
                this.func_149676_a(0.0f, -yM, 0.0f, 1.0f, 3 - yM, 1.0f);
            }
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int these, float are, float some, float variables) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null || !(te instanceof TileEssentiaCompressor)) {
            return false;
        }
        if (((TileEssentiaCompressor)te).isMultiblockFormed()) {
            if (!((TileEssentiaCompressor)te).isMasterTile()) {
                int yOffset = ((TileEssentiaCompressor)te).getMultiblockYIndex();
                return RegisteredBlocks.blockEssentiaCompressor.func_149727_a(world, x, y - yOffset, z, player, these, are, some, variables);
            }
        } else {
            ItemStack heldItem = player.func_70694_bm();
            if (heldItem != null && heldItem.func_77973_b() instanceof ItemWandCasting && ResearchManager.isResearchComplete((String)player.func_70005_c_(), (String)SimpleResearchItem.getFullName("ESSENTIA_COMPRESSOR"))) {
                boolean canForm;
                ChunkCoordinates lowest = this.findLowestCompressorBlock(world, x, y, z);
                boolean bl = canForm = lowest != null && this.isMuliblockPossible(world, lowest);
                if (canForm && ThaumcraftApiHelper.consumeVisFromWandCrafting((ItemStack)player.func_71045_bC(), (EntityPlayer)player, (AspectList)RegisteredRecipes.costsCompressorMultiblock, (boolean)true)) {
                    int multiblockID = TileEssentiaCompressor.getAndIncrementNewMultiblockId();
                    TileEssentiaCompressor compressor = (TileEssentiaCompressor)world.func_147438_o(lowest.field_71574_a, lowest.field_71572_b, lowest.field_71573_c);
                    compressor.setInMultiblock(true, 0, multiblockID);
                    PacketStartAnimation pkt = new PacketStartAnimation(4, lowest.field_71574_a, lowest.field_71572_b, lowest.field_71573_c);
                    NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)lowest.field_71574_a, (double)lowest.field_71572_b, (double)lowest.field_71573_c, 32.0);
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)pkt, point);
                    compressor = (TileEssentiaCompressor)world.func_147438_o(lowest.field_71574_a, lowest.field_71572_b + 1, lowest.field_71573_c);
                    compressor.setInMultiblock(false, 1, multiblockID);
                    pkt = new PacketStartAnimation(4, lowest.field_71574_a, lowest.field_71572_b + 1, lowest.field_71573_c);
                    point = new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)lowest.field_71574_a, (double)(lowest.field_71572_b + 1), (double)lowest.field_71573_c, 32.0);
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)pkt, point);
                    compressor = (TileEssentiaCompressor)world.func_147438_o(lowest.field_71574_a, lowest.field_71572_b + 2, lowest.field_71573_c);
                    compressor.setInMultiblock(false, 2, multiblockID);
                    pkt = new PacketStartAnimation(4, lowest.field_71574_a, lowest.field_71572_b + 2, lowest.field_71573_c);
                    point = new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)lowest.field_71574_a, (double)(lowest.field_71572_b + 2), (double)lowest.field_71573_c, 32.0);
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)pkt, point);
                }
            }
        }
        return false;
    }

    private boolean isMuliblockPossible(World world, ChunkCoordinates lowest) {
        return lowest != null && this.isMultiblockable(world, lowest.field_71574_a, lowest.field_71572_b, lowest.field_71573_c) && this.isMultiblockable(world, lowest.field_71574_a, lowest.field_71572_b + 1, lowest.field_71573_c) && this.isMultiblockable(world, lowest.field_71574_a, lowest.field_71572_b + 2, lowest.field_71573_c);
    }

    private ChunkCoordinates findLowestCompressorBlock(World world, int x, int y, int z) {
        ChunkCoordinates result = null;
        for (int i = 0; i <= y && this.isMultiblockable(world, x, y - i, z); ++i) {
            result = new ChunkCoordinates(x, y - i, z);
        }
        return result;
    }

    private boolean isMultiblockable(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        if (!block.equals(RegisteredBlocks.blockEssentiaCompressor)) {
            return false;
        }
        if (te == null || !(te instanceof TileEssentiaCompressor)) {
            return false;
        }
        TileEssentiaCompressor compressor = (TileEssentiaCompressor)te;
        return !compressor.isMultiblockFormed();
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEssentiaCompressor();
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }
}

