/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.research;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import makeo.gadomancy.common.research.SimpleResearchItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;

public class PseudoResearchItem
extends SimpleResearchItem {
    private static final String PSEUDO_PREFIX = "PSEUDO.";
    private final ResearchItem original;

    private PseudoResearchItem(ResearchItem original, String key, int col, int row, ResourceLocation icon, boolean doubleThisPage) {
        super(PSEUDO_PREFIX + key + (doubleThisPage ? ".2" : ""), col, row, original.getComplexity(), icon, new AspectList());
        this.original = original;
        this.setStub().setHidden();
    }

    private PseudoResearchItem(ResearchItem original, String key, int col, int row, ItemStack icon, boolean doubleThisPage) {
        super(PSEUDO_PREFIX + key + (doubleThisPage ? ".2" : ""), col, row, original.getComplexity(), icon, new AspectList());
        this.original = original;
        this.setStub().setHidden();
    }

    public ResearchPage[] getPages() {
        return this.original.getPages();
    }

    public String getName() {
        return this.original.getName();
    }

    public String getText() {
        return this.original.getText();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isHidden() {
        EntityClientPlayerMP p = Minecraft.func_71410_x().field_71439_g;
        if (p != null && !ThaumcraftApiHelper.isResearchComplete((String)p.func_70005_c_(), (String)this.key)) {
            return false;
        }
        return super.isHidden();
    }

    public static ResearchItem create(String original, int col, int row) {
        return PseudoResearchItem.create(original, col, row, false);
    }

    public static ResearchItem create(String original, int col, int row, boolean doubleInThisPage) {
        ResearchItem item = ResearchCategories.getResearch((String)original);
        if (item != null) {
            PseudoResearchItem pseudo = item.icon_resource == null ? new PseudoResearchItem(item, item.key, col, row, item.icon_item, doubleInThisPage) : new PseudoResearchItem(item, item.key, col, row, item.icon_resource, doubleInThisPage);
            String[] siblings = item.siblings;
            if (siblings == null) {
                siblings = new String[]{pseudo.key};
            } else {
                siblings = Arrays.copyOf(siblings, siblings.length + 1);
                siblings[siblings.length - 1] = pseudo.key;
            }
            item.setSiblings(siblings);
            if (item.isSecondary()) {
                pseudo.setSecondary();
            }
            return pseudo.setParentsHidden(new String[]{original});
        }
        return null;
    }
}

