/*
 * Decompiled with CFR 0.152.
 */
package bartworks.system.material.werkstoff_loaders.recipe;

import bartworks.system.material.Werkstoff;
import bartworks.system.material.werkstoff_loaders.IWerkstoffRunnable;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;

public class CraftingMaterialLoader
implements IWerkstoffRunnable {
    @Override
    public void run(Werkstoff werkstoff) {
        if (werkstoff.hasItemType(OrePrefixes.screw)) {
            int tVoltageMultiplier = werkstoff.getStats().getMeltingPoint() >= 2800 ? 60 : 15;
            GTValues.RA.stdBuilder().itemInputs(werkstoff.hasItemType(OrePrefixes.gem) ? werkstoff.get(OrePrefixes.gem) : werkstoff.get(OrePrefixes.ingot), ItemList.Shape_Extruder_Bolt.get(0L, new Object[0])).itemOutputs(werkstoff.get(OrePrefixes.bolt, 8)).duration((int)Math.max(werkstoff.getStats().getMass() * 2L, 1L)).eut(8 * tVoltageMultiplier).addTo(RecipeMaps.extruderRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.stick)).itemOutputs(werkstoff.get(OrePrefixes.bolt, 4)).duration((int)Math.max(werkstoff.getStats().getMass() * 2L, 1L)).eut(4).addTo(RecipeMaps.cutterRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.bolt)).itemOutputs(werkstoff.get(OrePrefixes.screw)).duration((int)Math.max(werkstoff.getStats().getMass() / 8L, 1L)).eut(4).addTo(RecipeMaps.latheRecipes);
            GTModHandler.addCraftingRecipe(werkstoff.get(OrePrefixes.screw), GTModHandler.RecipeBits.BITS_STD, new Object[]{"fX", "X ", Character.valueOf('X'), werkstoff.get(OrePrefixes.bolt)});
            if (werkstoff.hasItemType(OrePrefixes.gem)) {
                return;
            }
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.ingot), ItemList.Shape_Extruder_Ring.get(0L, new Object[0])).itemOutputs(werkstoff.get(OrePrefixes.ring, 4)).duration((int)Math.max(werkstoff.getStats().getMass() * 2L, 1L)).eut(6 * tVoltageMultiplier).addTo(RecipeMaps.extruderRecipes);
            GTModHandler.addCraftingRecipe(werkstoff.get(OrePrefixes.ring), GTModHandler.RecipeBits.BITS_STD, new Object[]{"h ", "fX", Character.valueOf('X'), werkstoff.get(OrePrefixes.stick)});
            GTModHandler.addCraftingRecipe(werkstoff.get(OrePrefixes.gearGt), GTModHandler.RecipeBits.BITS_STD, new Object[]{"SPS", "PwP", "SPS", Character.valueOf('P'), werkstoff.get(OrePrefixes.plate), Character.valueOf('S'), werkstoff.get(OrePrefixes.stick)});
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.ingot, 4), ItemList.Shape_Extruder_Gear.get(0L, new Object[0])).itemOutputs(werkstoff.get(OrePrefixes.gearGt)).duration((int)Math.max(werkstoff.getStats().getMass() * 5L, 1L)).eut(8 * tVoltageMultiplier).addTo(RecipeMaps.extruderRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.ingot), ItemList.Shape_Extruder_Wire.get(0L, new Object[0])).itemOutputs(werkstoff.get(OrePrefixes.wireFine, 8)).duration((int)Math.max((float)werkstoff.getStats().getMass() * 1.5f, 1.0f)).eut(8 * tVoltageMultiplier).addTo(RecipeMaps.extruderRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.ingot), GTUtility.getIntegratedCircuit(3)).itemOutputs(werkstoff.get(OrePrefixes.wireFine, 8)).duration((int)Math.max(werkstoff.getStats().getMass(), 1L)).eut(8 * tVoltageMultiplier).addTo(RecipeMaps.wiremillRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.stick), GTUtility.getIntegratedCircuit(3)).itemOutputs(werkstoff.get(OrePrefixes.wireFine, 4)).duration((int)Math.max((float)werkstoff.getStats().getMass() * 0.5f, 1.0f)).eut(8 * tVoltageMultiplier).addTo(RecipeMaps.wiremillRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.ingot), ItemList.Shape_Extruder_Small_Gear.get(0L, new Object[0])).itemOutputs(werkstoff.get(OrePrefixes.gearGtSmall)).duration((int)werkstoff.getStats().getMass()).eut(8 * tVoltageMultiplier).addTo(RecipeMaps.extruderRecipes);
            GTModHandler.addCraftingRecipe(werkstoff.get(OrePrefixes.gearGtSmall), GTModHandler.RecipeBits.BITS_STD, new Object[]{" S ", "hPx", " S ", Character.valueOf('S'), werkstoff.get(OrePrefixes.stick), Character.valueOf('P'), werkstoff.get(OrePrefixes.plate)});
            GTModHandler.addCraftingRecipe(werkstoff.get(OrePrefixes.rotor), GTModHandler.RecipeBits.BITS_STD, new Object[]{"PhP", "SRf", "PdP", Character.valueOf('P'), werkstoff.get(OrePrefixes.plate), Character.valueOf('R'), werkstoff.get(OrePrefixes.ring), Character.valueOf('S'), werkstoff.get(OrePrefixes.screw)});
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.plate, 4), werkstoff.get(OrePrefixes.ring)).itemOutputs(werkstoff.get(OrePrefixes.rotor)).fluidInputs(Materials.Tin.getMolten(32L)).duration(240).eut(24).addTo(RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.plate, 4), werkstoff.get(OrePrefixes.ring)).itemOutputs(werkstoff.get(OrePrefixes.rotor)).fluidInputs(Materials.Lead.getMolten(48L)).duration(240).eut(24).addTo(RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.plate, 4), werkstoff.get(OrePrefixes.ring)).itemOutputs(werkstoff.get(OrePrefixes.rotor)).fluidInputs(Materials.SolderingAlloy.getMolten(16L)).duration(240).eut(24).addTo(RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.ingot, 5), ItemList.Shape_Extruder_Rotor.get(0L, new Object[0])).itemOutputs(werkstoff.get(OrePrefixes.rotor)).duration(200).eut(60).addTo(RecipeMaps.extruderRecipes);
        }
    }
}

