/*
 * Decompiled with CFR 0.152.
 */
package bartworks.system.material.werkstoff_loaders.recipe;

import bartworks.system.material.Werkstoff;
import bartworks.system.material.werkstoff_loaders.IWerkstoffRunnable;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;

public class CrushedLoader
implements IWerkstoffRunnable {
    @Override
    public void run(Werkstoff werkstoff) {
        if (!werkstoff.hasItemType(OrePrefixes.ore) || !werkstoff.hasItemType(OrePrefixes.dust)) {
            return;
        }
        if (werkstoff.hasItemType(OrePrefixes.ingot) && !werkstoff.getStats().isBlastFurnace()) {
            if (Werkstoff.Types.ELEMENT.equals((Object)werkstoff.getType())) {
                GTModHandler.addSmeltingRecipe(werkstoff.get(OrePrefixes.crushed), werkstoff.get(OrePrefixes.nugget, 10));
                GTModHandler.addSmeltingRecipe(werkstoff.get(OrePrefixes.crushedPurified), werkstoff.get(OrePrefixes.nugget, 10));
                GTModHandler.addSmeltingRecipe(werkstoff.get(OrePrefixes.crushedCentrifuged), werkstoff.get(OrePrefixes.nugget, 10));
            } else {
                GTModHandler.addSmeltingRecipe(werkstoff.get(OrePrefixes.crushed), werkstoff.get(OrePrefixes.ingot));
                GTModHandler.addSmeltingRecipe(werkstoff.get(OrePrefixes.crushedPurified), werkstoff.get(OrePrefixes.ingot));
                GTModHandler.addSmeltingRecipe(werkstoff.get(OrePrefixes.crushedCentrifuged), werkstoff.get(OrePrefixes.ingot));
            }
            GTModHandler.addSmeltingRecipe(werkstoff.get(OrePrefixes.dustImpure), werkstoff.get(OrePrefixes.ingot));
            GTModHandler.addSmeltingRecipe(werkstoff.get(OrePrefixes.dustPure), werkstoff.get(OrePrefixes.ingot));
            GTModHandler.addSmeltingRecipe(werkstoff.get(OrePrefixes.dust), werkstoff.get(OrePrefixes.ingot));
        }
        GTModHandler.addCraftingRecipe(werkstoff.get(OrePrefixes.dustImpure), new Object[]{"h  ", "W  ", Character.valueOf('W'), werkstoff.get(OrePrefixes.crushed)});
        GTModHandler.addCraftingRecipe(werkstoff.get(OrePrefixes.dustPure), new Object[]{"h  ", "W  ", Character.valueOf('W'), werkstoff.get(OrePrefixes.crushedPurified)});
        GTModHandler.addCraftingRecipe(werkstoff.get(OrePrefixes.dust), new Object[]{"h  ", "W  ", Character.valueOf('W'), werkstoff.get(OrePrefixes.crushedCentrifuged)});
        GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.crushed)).itemOutputs(werkstoff.get(OrePrefixes.dustImpure)).duration(10).eut(16).addTo(RecipeMaps.hammerRecipes);
        GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.crushed)).itemOutputs(werkstoff.get(OrePrefixes.dustImpure), werkstoff.getOreByProduct(0, OrePrefixes.dust)).outputChances(10000, 1000).eut(2).duration(400).addTo(RecipeMaps.maceratorRecipes);
        GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.crushed)).itemOutputs(werkstoff.get(OrePrefixes.crushedPurified), werkstoff.getOreByProduct(0, OrePrefixes.dust), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Stone, 1L)).outputChances(10000, 1111, 10000).fluidInputs(Materials.Water.getFluid(1000L)).duration(500).eut(16).addTo(RecipeMaps.oreWasherRecipes);
        GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.crushed)).itemOutputs(werkstoff.get(OrePrefixes.crushedPurified), werkstoff.getOreByProduct(0, OrePrefixes.dust), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Stone, 1L)).outputChances(10000, 1111, 10000).fluidInputs(GTModHandler.getDistilledWater(200L)).duration(300).eut(16).addTo(RecipeMaps.oreWasherRecipes);
        GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.crushed)).itemOutputs(werkstoff.get(OrePrefixes.crushedCentrifuged), werkstoff.getOreByProduct(1, OrePrefixes.dust), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Stone, 1L)).outputChances(10000, 1111, 10000).duration(500).eut(48).addTo(RecipeMaps.thermalCentrifugeRecipes);
        GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.crushedPurified)).itemOutputs(werkstoff.get(OrePrefixes.dustPure)).duration(10).eut(16).addTo(RecipeMaps.hammerRecipes);
        GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.crushedPurified)).itemOutputs(werkstoff.get(OrePrefixes.dustPure), werkstoff.getOreByProduct(1, OrePrefixes.dust)).outputChances(10000, 1000).eut(2).duration(400).addTo(RecipeMaps.maceratorRecipes);
        GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.crushedPurified)).itemOutputs(werkstoff.get(OrePrefixes.crushedCentrifuged), werkstoff.getOreByProduct(1, OrePrefixes.dust)).outputChances(10000, 1111).duration(500).eut(48).addTo(RecipeMaps.thermalCentrifugeRecipes);
        GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.crushedCentrifuged)).itemOutputs(werkstoff.get(OrePrefixes.dust)).duration(10).eut(16).addTo(RecipeMaps.hammerRecipes);
        GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.crushedCentrifuged)).itemOutputs(werkstoff.get(OrePrefixes.dust), werkstoff.getOreByProduct(2, OrePrefixes.dust)).outputChances(10000, 1000).eut(2).duration(400).addTo(RecipeMaps.maceratorRecipes);
        GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.dustImpure)).itemOutputs(werkstoff.get(OrePrefixes.dust), werkstoff.getOreByProduct(0, OrePrefixes.dust)).outputChances(10000, 1111).duration(Math.max(1L, werkstoff.getStats().getMass() * 8L)).eut(5).addTo(RecipeMaps.centrifugeRecipes);
        GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.dustPure)).itemOutputs(werkstoff.get(OrePrefixes.dust), werkstoff.getOreByProduct(1, OrePrefixes.dust)).outputChances(10000, 1111).duration(Math.max(1L, werkstoff.getStats().getMass() * 8L)).eut(5).addTo(RecipeMaps.centrifugeRecipes);
        if (werkstoff.contains(SubTag.CRYSTALLISABLE)) {
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.dustPure)).itemOutputs(werkstoff.get(OrePrefixes.gem)).outputChances(9500).fluidInputs(Materials.Water.getFluid(200L)).duration(2000).eut(24).addTo(RecipeMaps.autoclaveRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.dustImpure)).itemOutputs(werkstoff.get(OrePrefixes.gem)).outputChances(9000).fluidInputs(Materials.Water.getFluid(200L)).duration(2000).eut(24).addTo(RecipeMaps.autoclaveRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.dustPure)).itemOutputs(werkstoff.get(OrePrefixes.gem)).outputChances(10000).fluidInputs(GTModHandler.getDistilledWater(200L)).duration(1500).eut(24).addTo(RecipeMaps.autoclaveRecipes);
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.dustImpure)).itemOutputs(werkstoff.get(OrePrefixes.gem)).outputChances(9500).fluidInputs(GTModHandler.getDistilledWater(200L)).duration(1500).eut(24).addTo(RecipeMaps.autoclaveRecipes);
        }
        if (werkstoff.contains(SubTag.WASHING_MERCURY)) {
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.crushed)).itemOutputs(werkstoff.get(OrePrefixes.crushedPurified), werkstoff.getOreByProduct(1, OrePrefixes.dust), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Stone, 1L)).outputChances(10000, 7000, 4000).fluidInputs(Materials.Mercury.getFluid(1000L)).duration(800).eut(8).addTo(RecipeMaps.chemicalBathRecipes);
        }
        if (werkstoff.contains(SubTag.WASHING_SODIUMPERSULFATE)) {
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.crushed)).itemOutputs(werkstoff.get(OrePrefixes.crushedPurified), werkstoff.getOreByProduct(1, OrePrefixes.dust), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Stone, 1L)).outputChances(10000, 7000, 4000).fluidInputs(Materials.SodiumPersulfate.getFluid(100L)).duration(800).eut(8).addTo(RecipeMaps.chemicalBathRecipes);
        }
        if (werkstoff.contains(SubTag.ELECTROMAGNETIC_SEPERATION_GOLD)) {
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.dustPure)).itemOutputs(werkstoff.get(OrePrefixes.dust), GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Gold, 1L), GTOreDictUnificator.get(OrePrefixes.nugget, Materials.Gold, 1L)).outputChances(10000, 4000, 2000).duration(400).eut(24).addTo(RecipeMaps.electroMagneticSeparatorRecipes);
        } else if (werkstoff.contains(SubTag.ELECTROMAGNETIC_SEPERATION_IRON)) {
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.dustPure)).itemOutputs(werkstoff.get(OrePrefixes.dust), GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Iron, 1L), GTOreDictUnificator.get(OrePrefixes.nugget, Materials.Iron, 1L)).outputChances(10000, 4000, 2000).duration(400).eut(24).addTo(RecipeMaps.electroMagneticSeparatorRecipes);
        } else if (werkstoff.contains(SubTag.ELECTROMAGNETIC_SEPERATION_NEODYMIUM)) {
            GTValues.RA.stdBuilder().itemInputs(werkstoff.get(OrePrefixes.dustPure)).itemOutputs(werkstoff.get(OrePrefixes.dust), GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Neodymium, 1L), GTOreDictUnificator.get(OrePrefixes.nugget, Materials.Neodymium, 1L)).outputChances(10000, 4000, 2000).duration(400).eut(24).addTo(RecipeMaps.electroMagneticSeparatorRecipes);
        }
    }
}

