/*
 * Decompiled with CFR 0.152.
 */
package bwcrossmod.galacticgreg;

import bwcrossmod.galacticgreg.VoidMinerUtility;
import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.tileentities.machines.multi.MTEDrillerBase;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public abstract class MTEVoidMinerBase<T extends MTEVoidMinerBase<T>>
extends MTEEnhancedMultiBlockBase<T>
implements ISurvivalConstructable {
    private VoidMinerUtility.DropMap dropMap = null;
    private VoidMinerUtility.DropMap extraDropMap = null;
    protected int casingTextureIndex;
    private float totalWeight;
    private int multiplier = 1;
    protected final byte TIER_MULTIPLIER;
    private boolean mBlacklist = false;
    int batchMultiplier = 1;

    @Deprecated
    public static void addBlockToDimensionList(int dimId, Block block, int meta, float weight) {
        VoidMinerUtility.addBlockToDimensionList(dimId, block, meta, weight);
    }

    public MTEVoidMinerBase(int aID, String aName, String aNameRegional, int tier) {
        super(aID, aName, aNameRegional);
        this.TIER_MULTIPLIER = (byte)Math.max(tier, 1);
        this.casingTextureIndex = this.getControllerTextureIndex();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mBlacklist", this.mBlacklist);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mBlacklist = aNBT.func_74767_n("mBlacklist");
    }

    public MTEVoidMinerBase(String aName, int tier) {
        super(aName);
        this.TIER_MULTIPLIER = (byte)tier;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        this.setElectricityStats();
        if (this.working()) {
            return SimpleCheckRecipeResult.ofSuccess("drill_extracting_ores");
        }
        return SimpleCheckRecipeResult.ofFailure("drill_extracting_ores_failed");
    }

    protected int getMinTier() {
        return this.TIER_MULTIPLIER + 5;
    }

    protected void setElectricityStats() {
        this.batchMultiplier = this.batchMode ? 16 : 1;
        this.mEUt = -Math.abs(Math.toIntExact(GTValues.V[this.getMinTier()]));
        this.mOutputItems = GTValues.emptyItemStackArray;
        this.mProgresstime = 0;
        this.mMaxProgresstime = 10 * this.batchMultiplier;
        this.mEfficiency = this.getCurrentEfficiency(null);
        this.mEfficiencyIncrease = 10000;
        this.mEUt = this.mEUt > 0 ? -this.mEUt : this.mEUt;
    }

    protected boolean working() {
        if (this.dropMap == null || this.totalWeight == 0.0f) {
            this.calculateDropMap();
        }
        if (this.totalWeight != 0.0f) {
            this.handleFluidConsumption();
            return true;
        }
        this.stopMachine(ShutDownReasonRegistry.NONE);
        return false;
    }

    @Override
    protected void outputAfterRecipe() {
        if (this.totalWeight != 0.0f) {
            this.handleOutputs();
        }
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Miner").addInfo("Consumes " + GTValues.V[this.getMinTier()] + "EU/t").addInfo("Can be supplied with " + EnumChatFormatting.AQUA + "2 L/s" + EnumChatFormatting.GRAY + " of Noble gases to boost " + EnumChatFormatting.GOLD + "output").addInfo(this.createGasString(EnumChatFormatting.LIGHT_PURPLE, "Neon", 4)).addInfo(this.createGasString(EnumChatFormatting.AQUA, "Krypton", 8)).addInfo(this.createGasString(EnumChatFormatting.DARK_AQUA, "Xenon", 16)).addInfo(this.createGasString(EnumChatFormatting.BLUE, "Oganesson", 64)).addInfo("Will output " + 2 * this.TIER_MULTIPLIER + " Ores per Second depending on the Dimension it is build in").addInfo("Put the Ore into the input bus to set the Whitelist/Blacklist").addInfo("Use a screwdriver to toggle Whitelist/Blacklist").addInfo("You can enable batch mode with wire cutters." + EnumChatFormatting.BLUE + " 16x Time 16x Output").addInfo("Blacklist or non Whitelist Ore will be " + EnumChatFormatting.DARK_RED + "VOIDED" + EnumChatFormatting.RESET + ".").toolTipFinisher(new String[0]);
        return tt;
    }

    protected List<IHatchElement<? super MTEDrillerBase>> getAllowedHatches() {
        return ImmutableList.of((Object)HatchElement.InputHatch, (Object)HatchElement.InputBus, (Object)HatchElement.OutputBus, (Object)HatchElement.Maintenance, (Object)HatchElement.Energy);
    }

    private ItemStack nextOre() {
        return this.dropMap.nextOre().getItemStack();
    }

    private FluidStack getNobleGasInputAndSetMultiplier() {
        for (FluidStack s : this.getStoredFluids()) {
            for (int i = 0; i < VoidMinerUtility.NOBLE_GASSES.length; ++i) {
                FluidStack ng = VoidMinerUtility.NOBLE_GASSES[i];
                if (!ng.isFluidEqual(s)) continue;
                this.multiplier = this.TIER_MULTIPLIER * VoidMinerUtility.NOBLE_GASSES_MULTIPLIER[i];
                return s;
            }
        }
        return null;
    }

    private boolean consumeNobleGas(FluidStack gasToConsume) {
        for (FluidStack s : this.getStoredFluids()) {
            if (!s.isFluidEqual(gasToConsume) || s.amount < this.batchMultiplier) continue;
            s.amount -= this.batchMultiplier;
            this.updateSlots();
            return true;
        }
        return false;
    }

    private void handleFluidConsumption() {
        FluidStack storedNobleGas = this.getNobleGasInputAndSetMultiplier();
        if (storedNobleGas == null || !this.consumeNobleGas(storedNobleGas)) {
            this.multiplier = this.TIER_MULTIPLIER;
        }
    }

    private void handleExtraDrops(int id) {
        this.extraDropMap = new VoidMinerUtility.DropMap();
        if (VoidMinerUtility.extraDropsDimMap.containsKey(id)) {
            this.extraDropMap = VoidMinerUtility.extraDropsDimMap.get(id);
        }
    }

    private void handleModDimDef(int id) {
        if (VoidMinerUtility.dropMapsByDimId.containsKey(id)) {
            this.dropMap = VoidMinerUtility.dropMapsByDimId.get(id);
            return;
        }
        String chunkProviderName = ((ChunkProviderServer)this.getBaseMetaTileEntity().getWorld().func_72863_F()).field_73246_d.getClass().getName();
        if (VoidMinerUtility.dropMapsByChunkProviderName.containsKey(chunkProviderName)) {
            this.dropMap = VoidMinerUtility.dropMapsByChunkProviderName.get(chunkProviderName);
            return;
        }
        this.dropMap = new VoidMinerUtility.DropMap();
        VoidMinerUtility.dropMapsByDimId.put(id, this.dropMap);
    }

    private void calculateDropMap() {
        int id = this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g;
        this.handleModDimDef(id);
        this.handleExtraDrops(id);
        this.dropMap.isDistributionCached(this.extraDropMap);
        this.totalWeight = this.dropMap.getTotalWeight();
    }

    private void handleOutputs() {
        List inputOres = this.getStoredInputs().stream().filter(GTUtility::isOre).collect(Collectors.toList());
        ItemStack output = this.nextOre();
        output.field_77994_a = this.multiplier * this.batchMultiplier;
        if (inputOres.isEmpty() || this.mBlacklist && inputOres.stream().noneMatch(is -> GTUtility.areStacksEqual(is, output)) || !this.mBlacklist && inputOres.stream().anyMatch(is -> GTUtility.areStacksEqual(is, output))) {
            this.addOutput(output);
        }
        this.updateSlots();
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        this.mBlacklist = !this.mBlacklist;
        GTUtility.sendChatToPlayer(aPlayer, "Mode: " + (this.mBlacklist ? "Blacklist" : "Whitelist"));
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        this.batchMode = !this.batchMode;
        GTUtility.sendChatToPlayer(aPlayer, "Batch Mode: " + (this.batchMode ? "Enabled" : "Disabled"));
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (sideDirection == facingDirection) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.casingTextureIndex), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ORE_DRILL_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ORE_DRILL_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.casingTextureIndex), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ORE_DRILL).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ORE_DRILL_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(this.casingTextureIndex)};
    }

    protected boolean checkHatches() {
        return !this.mMaintenanceHatches.isEmpty() && !this.mOutputBusses.isEmpty() && !this.mEnergyHatches.isEmpty();
    }

    public abstract int survivalConstruct(ItemStack var1, int var2, ISurvivalBuildEnvironment var3);

    protected abstract int getControllerTextureIndex();

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    protected String createGasString(EnumChatFormatting color, String gas, int boost) {
        return String.format("%s%s%s : %s%dx%s", color, gas, EnumChatFormatting.GRAY, EnumChatFormatting.GOLD, boost, EnumChatFormatting.GRAY);
    }
}

